/*
 * Decompiled with CFR 0.152.
 */
package hprose.io;

import hprose.common.HproseException;
import hprose.io.ByteBufferInputStream;
import hprose.io.ByteBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public final class ByteBufferStream {
    private static final ThreadLocal<ByteBufferPool> byteBufferPool = new ThreadLocal<ByteBufferPool>(){

        @Override
        protected ByteBufferPool initialValue() {
            return new ByteBufferPool();
        }
    };
    public ByteBuffer buffer;
    InputStream istream;
    OutputStream ostream;

    private static int pow2roundup(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static final ByteBuffer allocate(int capacity) {
        return ByteBufferStream.byteBufferPool.get().allocate(capacity);
    }

    public static final void free(ByteBuffer buffer) {
        ByteBufferStream.byteBufferPool.get().free(buffer);
    }

    public ByteBufferStream() {
        this(1024);
    }

    public ByteBufferStream(int capacity) {
        this.buffer = ByteBufferStream.allocate(capacity);
    }

    public ByteBufferStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public static final ByteBufferStream wrap(byte[] array, int offset, int length) {
        return new ByteBufferStream(ByteBuffer.wrap(array, offset, length));
    }

    public static final ByteBufferStream wrap(byte[] array) {
        return new ByteBufferStream(ByteBuffer.wrap(array));
    }

    public final void close() {
        if (this.buffer != null) {
            ByteBufferStream.free(this.buffer);
            this.buffer = null;
        }
    }

    public final InputStream getInputStream() {
        if (this.istream == null) {
            this.istream = new ByteBufferInputStream(this);
        }
        return this.istream;
    }

    public final OutputStream getOutputStream() {
        if (this.ostream == null) {
            this.ostream = new ByteBufferOutputStream(this);
        }
        return this.ostream;
    }

    public final int read() {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    public final int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) {
        if (len <= 0) {
            return 0;
        }
        int remain = this.buffer.remaining();
        if (remain <= 0) {
            return -1;
        }
        if (len >= remain) {
            this.buffer.get(b, off, remain);
            return remain;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    public final int read(ByteBuffer b) {
        int len = b.remaining();
        if (len <= 0) {
            return 0;
        }
        int remain = this.buffer.remaining();
        if (remain <= 0) {
            return -1;
        }
        if (len >= remain) {
            b.put(this.buffer);
            return remain;
        }
        int oldlimit = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + len);
        b.put(this.buffer);
        this.buffer.limit(oldlimit);
        return len;
    }

    public final long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int remain = this.buffer.remaining();
        if (remain <= 0) {
            return 0L;
        }
        if (n > (long)remain) {
            this.buffer.position(this.buffer.limit());
            return remain;
        }
        this.buffer.position(this.buffer.position() + (int)n);
        return n;
    }

    public final int available() {
        return this.buffer.remaining();
    }

    public final boolean markSupported() {
        return true;
    }

    public final void mark(int readlimit) {
        this.buffer.mark();
    }

    public final void reset() {
        this.buffer.reset();
    }

    private void grow(int n) {
        if (this.buffer.remaining() < n) {
            int required = this.buffer.position() + n;
            if (required > this.buffer.capacity()) {
                int size = ByteBufferStream.pow2roundup(required);
                ByteBuffer buf = ByteBufferStream.allocate(size);
                this.buffer.flip();
                buf.put(this.buffer);
                ByteBufferStream.free(this.buffer);
                this.buffer = buf;
            } else {
                this.buffer.limit(required);
            }
        }
    }

    public final void write(int b) {
        this.grow(1);
        this.buffer.put((byte)b);
    }

    public final void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public final void write(byte[] b, int off, int len) {
        this.grow(len);
        this.buffer.put(b, off, len);
    }

    public final void write(ByteBuffer b) {
        this.grow(b.remaining());
        this.buffer.put(b);
    }

    public final void flip() {
        if (this.buffer.position() != 0) {
            this.buffer.flip();
        }
    }

    public final void rewind() {
        this.buffer.rewind();
    }

    public final byte[] toArray() {
        this.flip();
        byte[] data = new byte[this.buffer.limit()];
        this.buffer.get(data);
        return data;
    }

    public final void readFrom(InputStream istream) throws IOException {
        int n;
        byte[] b = new byte[8192];
        while ((n = istream.read(b)) != -1) {
            this.write(b, 0, n);
        }
    }

    public final void writeTo(OutputStream ostream) throws IOException {
        if (this.buffer.hasArray()) {
            ostream.write(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining());
        } else {
            int n;
            byte[] b = new byte[8192];
            while ((n = this.read(b)) != -1) {
                ostream.write(b, 0, n);
            }
        }
    }

    public final void readFrom(ByteChannel channel, int length) throws IOException {
        int n;
        int nn;
        this.grow(length);
        this.buffer.limit(this.buffer.position() + length);
        for (n = 0; n < length && (nn = channel.read(this.buffer)) != -1; n += nn) {
        }
        if (n < length) {
            throw new HproseException("Unexpected EOF");
        }
    }

    public final void writeTo(ByteChannel channel) throws IOException {
        while (this.buffer.hasRemaining()) {
            channel.write(this.buffer);
        }
    }

    static final class ByteBufferPool {
        private final int POOLNUM = 12;
        private final int POOLSIZE = 32;
        private final ByteBuffer[][] pool = new ByteBuffer[12][];
        private final int[] position = new int[12];
        private static final int[] debruijn = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};

        private static int log2(int x) {
            return debruijn[(x & -x) * 125613361 >>> 27];
        }

        private ByteBufferPool() {
            for (int i = 0; i < 12; ++i) {
                this.pool[i] = new ByteBuffer[32];
                this.position[i] = -1;
            }
        }

        private ByteBuffer allocate(int capacity) {
            if ((capacity = ByteBufferStream.pow2roundup(capacity)) < 1024) {
                return ByteBuffer.allocate(capacity);
            }
            int index = ByteBufferPool.log2(capacity) - 10;
            if (index < 12 && this.position[index] >= 0) {
                int pos = this.position[index];
                ByteBuffer byteBuffer = this.pool[index][pos];
                this.pool[index][pos] = null;
                this.position[index] = pos - 1;
                if (byteBuffer != null) {
                    return byteBuffer;
                }
            }
            return ByteBuffer.allocateDirect(capacity);
        }

        private void free(ByteBuffer buffer) {
            int capacity;
            if (buffer.isDirect() && (capacity = buffer.capacity()) == ByteBufferStream.pow2roundup(capacity)) {
                int pos;
                buffer.clear();
                int index = ByteBufferPool.log2(capacity) - 10;
                if (index >= 0 && index < 12 && (pos = this.position[index]) < 31) {
                    this.pool[index][++pos] = buffer;
                    this.position[index] = pos;
                }
            }
        }
    }
}

