/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.ClientContext;
import hprose.client.FullDuplexSocketTransporter;
import hprose.client.HalfDuplexSocketTransporter;
import hprose.client.HproseClient;
import hprose.client.SocketTransporter;
import hprose.common.HproseException;
import hprose.common.InvokeSettings;
import hprose.io.HproseMode;
import hprose.util.concurrent.Promise;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;

public class HproseTcpClient
extends HproseClient {
    private static int reactorThreads = 2;
    private volatile boolean fullDuplex = false;
    private volatile boolean noDelay = false;
    private volatile int maxPoolSize = 4;
    private volatile int idleTimeout = 30000;
    private volatile int readTimeout = 30000;
    private volatile int writeTimeout = 30000;
    private volatile int connectTimeout = 30000;
    private volatile boolean keepAlive = true;
    private final SocketTransporter fdTrans = new FullDuplexSocketTransporter(this);
    private final SocketTransporter hdTrans = new HalfDuplexSocketTransporter(this);

    public static int getReactorThreads() {
        return reactorThreads;
    }

    public static void setReactorThreads(int aReactorThreads) {
        reactorThreads = aReactorThreads;
    }

    public HproseTcpClient() {
    }

    public HproseTcpClient(String uri) {
        super(uri);
    }

    public HproseTcpClient(HproseMode mode) {
        super(mode);
    }

    public HproseTcpClient(String uri, HproseMode mode) {
        super(uri, mode);
    }

    public HproseTcpClient(String[] uris) {
        super(uris);
    }

    public HproseTcpClient(String[] uris, HproseMode mode) {
        super(uris, mode);
    }

    public static HproseClient create(String uri, HproseMode mode) throws IOException, URISyntaxException {
        String scheme = new URI(uri).getScheme();
        if (!("tcp".equalsIgnoreCase(scheme) || "tcp4".equalsIgnoreCase(scheme) || "tcp6".equalsIgnoreCase(scheme))) {
            throw new HproseException("This client doesn't support " + scheme + " scheme.");
        }
        return new HproseTcpClient(uri, mode);
    }

    public static HproseClient create(String[] uris, HproseMode mode) throws IOException, URISyntaxException {
        int n = uris.length;
        for (int i = 0; i < n; ++i) {
            String scheme = new URI(uris[i]).getScheme();
            if ("tcp".equalsIgnoreCase(scheme) || "tcp4".equalsIgnoreCase(scheme) || "tcp6".equalsIgnoreCase(scheme)) continue;
            throw new HproseException("This client doesn't support " + scheme + " scheme.");
        }
        return new HproseTcpClient(uris, mode);
    }

    @Override
    public final void close() {
        this.fdTrans.close();
        this.hdTrans.close();
        super.close();
    }

    public final boolean isFullDuplex() {
        return this.fullDuplex;
    }

    public final void setFullDuplex(boolean fullDuplex) {
        this.fullDuplex = fullDuplex;
    }

    public final boolean isNoDelay() {
        return this.noDelay;
    }

    public final void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public final int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public final void setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must be great than 0");
        }
        this.maxPoolSize = maxPoolSize;
    }

    public final int getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("idleTimeout must be great than -1");
        }
        this.idleTimeout = idleTimeout;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(int readTimeout) {
        if (readTimeout < 1) {
            throw new IllegalArgumentException("readTimeout must be great than 0");
        }
        this.readTimeout = readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final void setWriteTimeout(int writeTimeout) {
        if (writeTimeout < 1) {
            throw new IllegalArgumentException("writeTimeout must be great than 0");
        }
        this.writeTimeout = writeTimeout;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 1) {
            throw new IllegalArgumentException("connectTimeout must be great than 0");
        }
        this.connectTimeout = connectTimeout;
    }

    public final boolean isKeepAlive() {
        return this.keepAlive;
    }

    public final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    protected Promise<ByteBuffer> sendAndReceive(ByteBuffer request, ClientContext context) {
        InvokeSettings settings = context.getSettings();
        if (this.fullDuplex) {
            return this.fdTrans.send(request, settings.getTimeout());
        }
        return this.hdTrans.send(request, settings.getTimeout());
    }
}

