/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.orm.loading.impl;

import java.util.Collection;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.search.orm.loading.impl.HibernateStatelessInitializer;
import org.hibernate.search.spi.InstanceInitializer;

public class HibernateSessionLoadingInitializer
extends HibernateStatelessInitializer
implements InstanceInitializer {
    private final SessionImplementor hibernateSession;

    public HibernateSessionLoadingInitializer(SessionImplementor hibernateSession) {
        this.hibernateSession = hibernateSession;
    }

    @Override
    public Object unproxy(Object instance) {
        if (instance instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)instance;
            LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
            Object initialized = lazyInitializer.getImplementation((SharedSessionContractImplementor)this.hibernateSession);
            if (initialized != null) {
                return initialized;
            }
            return this.hibernateSession.getPersistenceContext().unproxyAndReassociate((Object)proxy);
        }
        return instance;
    }

    @Override
    public <T> Collection<T> initializeCollection(Collection<T> value) {
        return value;
    }

    @Override
    public <K, V> Map<K, V> initializeMap(Map<K, V> value) {
        return value;
    }
}

