/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.WeakIdentityHashMap;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class IDUtils {
    private static final long MAX_OBJECT_ID = 0x3FFFFFFFFFFFFFFFL;
    private static final long MAX_DOUBLE_ID = Long.MAX_VALUE;
    private static final long ID_MASK_DOUBLE = 0L;
    private static final long ID_MASK_LONG = 2L;
    private static final long ID_MASK_OBJECT = 3L;
    private static final BigInteger ID_MASK_LONG_BI = BigInteger.valueOf(2L);
    private static final BigInteger ID_MASK_DOUBLE_BI = BigInteger.valueOf(0L);
    private static final int NUM_RESERVED_IDS = ReservedID.values().length;
    private static final long ID_OFFSET = 1 + NUM_RESERVED_IDS + PythonBuiltinClassType.values().length;
    public static final long ID_NONE = IDUtils.getId(ReservedID.none);
    public static final long ID_NOTIMPLEMENTED = IDUtils.getId(ReservedID.notImplemented);
    public static final long ID_ELLIPSIS = IDUtils.getId(ReservedID.ellipsis);
    public static final long ID_EMPTY_BYTES = IDUtils.getId(ReservedID.emptyBytes);
    public static final long ID_EMPTY_UNICODE = IDUtils.getId(ReservedID.emptyUnicode);
    public static final long ID_EMPTY_TUPLE = IDUtils.getId(ReservedID.emptyTuple);
    public static final long ID_EMPTY_FROZENSET = IDUtils.getId(ReservedID.emptyFrozenSet);
    private final Map<Object, Long> weakIdMap = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final Map<TruffleString, Long> weakStringIdMap = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicLong globalId = new AtomicLong(ID_OFFSET);

    private static long asMaskedReservedObjectId(long id) {
        assert (0L <= id && id < ID_OFFSET);
        return id << 2 | 3L;
    }

    public static long asMaskedObjectId(long id) {
        assert (Long.compareUnsigned(ID_OFFSET, id) <= 0 && Long.compareUnsigned(id, 0x3FFFFFFFFFFFFFFFL) <= 0);
        return id << 2 | 3L;
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger asMaskedBigIntId(long id, BigInteger mask) {
        return BigInteger.valueOf(id).shiftLeft(2).or(mask);
    }

    private static Object asMaskedId(long id, PythonObjectFactory factory, long max, long mask, BigInteger biMask) {
        if (Long.compareUnsigned(id, max) <= 0) {
            return id << 2 | mask;
        }
        return factory.createInt(IDUtils.asMaskedBigIntId(id, biMask));
    }

    private static long getId(ReservedID reservedID) {
        return IDUtils.asMaskedReservedObjectId(1 + reservedID.ordinal());
    }

    public static long getId(PythonBuiltinClassType classType) {
        return IDUtils.asMaskedReservedObjectId(1 + NUM_RESERVED_IDS + classType.ordinal());
    }

    public static Object getId(int id) {
        return (long)id << 2 | 2L;
    }

    public static Object getId(long id, PythonObjectFactory factory) {
        return IDUtils.asMaskedId(id, factory, 0x3FFFFFFFFFFFFFFFL, 2L, ID_MASK_LONG_BI);
    }

    public static Object getId(double id, PythonObjectFactory factory) {
        long ieee754 = Double.doubleToLongBits(id);
        return IDUtils.asMaskedId(ieee754, factory, Long.MAX_VALUE, 0L, ID_MASK_DOUBLE_BI);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private long getNextId() {
        return this.globalId.incrementAndGet();
    }

    public long getNextObjectId() {
        return IDUtils.asMaskedObjectId(this.getNextId());
    }

    @CompilerDirectives.TruffleBoundary
    public long getNextObjectId(Object object) {
        return this.weakIdMap.computeIfAbsent(object, value -> this.getNextObjectId());
    }

    @CompilerDirectives.TruffleBoundary
    public long getNextStringId(TruffleString string) {
        return this.weakStringIdMap.computeIfAbsent(string, value -> this.getNextObjectId());
    }

    private static enum ReservedID {
        none,
        notImplemented,
        ellipsis,
        emptyBytes,
        emptyUnicode,
        emptyTuple,
        emptyFrozenSet;

    }
}

