/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.locale;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleLogger;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LocaleUtils {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(LocaleUtils.class);
    private static final Pattern LOCALE_PATTERN = Pattern.compile("([a-zA-Z]{2,})(_(\\w{2,}))?(\\.([^@]*))?(@.*)?");

    private LocaleUtils() {
    }

    public static Locale fromPosix(String posixLocaleId, Locale defaultLocale) {
        CompilerAsserts.neverPartOfCompilation();
        if (posixLocaleId == null) {
            return null;
        }
        if (posixLocaleId.isEmpty()) {
            return defaultLocale;
        }
        if (posixLocaleId.toUpperCase(Locale.ROOT).equals("C")) {
            return Locale.ROOT;
        }
        Matcher m = LOCALE_PATTERN.matcher(posixLocaleId);
        if (!m.matches()) {
            LOGGER.fine("Could not parse POSIX locale: " + posixLocaleId);
            return null;
        }
        String language = m.group(1);
        String country = m.group(3);
        String codeset = m.group(5);
        if (codeset != null && !codeset.isEmpty() && !codeset.toUpperCase(Locale.ROOT).equals("UTF-8")) {
            LOGGER.fine("Non UTF-8 encoding in: " + posixLocaleId);
        }
        return country == null ? Locale.of(language) : Locale.of(language, country);
    }

    public static String toPosix(Locale locale) {
        CompilerAsserts.neverPartOfCompilation();
        if (locale == null) {
            return null;
        }
        if (locale.equals(Locale.ROOT)) {
            return "C";
        }
        StringBuilder builder = new StringBuilder();
        String language = locale.getLanguage();
        if (language.isEmpty()) {
            language = locale.getISO3Language();
        }
        if (!language.isEmpty()) {
            builder.append(language);
            String country = locale.getCountry();
            if (country.isEmpty()) {
                country = locale.getISO3Country();
            }
            if (!country.isEmpty()) {
                builder.append('_');
                builder.append(country.toUpperCase());
                Charset charset = Charset.defaultCharset();
                builder.append('.');
                builder.append(charset.name());
            }
        } else {
            return null;
        }
        return builder.toString();
    }
}

