/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.sst;

import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.BoolOpTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;

public abstract class ExprTy
extends SSTNode {
    ExprTy(SourceRange sourceRange) {
        super(sourceRange);
    }

    public static final class Slice
    extends ExprTy {
        public final ExprTy lower;
        public final ExprTy upper;
        public final ExprTy step;

        public Slice(ExprTy lower, ExprTy upper, ExprTy step, SourceRange sourceRange) {
            super(sourceRange);
            this.lower = lower;
            this.upper = upper;
            this.step = step;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Tuple
    extends ExprTy {
        public final ExprTy[] elements;
        public final ExprContextTy context;

        public Tuple(ExprTy[] elements, ExprContextTy context, SourceRange sourceRange) {
            super(sourceRange);
            this.elements = elements;
            assert (context != null);
            this.context = context;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class List
    extends ExprTy {
        public final ExprTy[] elements;
        public final ExprContextTy context;

        public List(ExprTy[] elements, ExprContextTy context, SourceRange sourceRange) {
            super(sourceRange);
            this.elements = elements;
            assert (context != null);
            this.context = context;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Name
    extends ExprTy {
        public final String id;
        public final ExprContextTy context;

        public Name(String id, ExprContextTy context, SourceRange sourceRange) {
            super(sourceRange);
            assert (id != null);
            this.id = id;
            assert (context != null);
            this.context = context;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Starred
    extends ExprTy {
        public final ExprTy value;
        public final ExprContextTy context;

        public Starred(ExprTy value, ExprContextTy context, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
            assert (context != null);
            this.context = context;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Subscript
    extends ExprTy {
        public final ExprTy value;
        public final ExprTy slice;
        public final ExprContextTy context;

        public Subscript(ExprTy value, ExprTy slice, ExprContextTy context, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
            assert (slice != null);
            this.slice = slice;
            assert (context != null);
            this.context = context;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Attribute
    extends ExprTy {
        public final ExprTy value;
        public final String attr;
        public final ExprContextTy context;

        public Attribute(ExprTy value, String attr, ExprContextTy context, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
            assert (attr != null);
            this.attr = attr;
            assert (context != null);
            this.context = context;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Constant
    extends ExprTy {
        public final ConstantValue value;
        public final Object kind;

        public Constant(ConstantValue value, Object kind, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
            this.kind = kind;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class JoinedStr
    extends ExprTy {
        public final ExprTy[] values;

        public JoinedStr(ExprTy[] values, SourceRange sourceRange) {
            super(sourceRange);
            this.values = values;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class FormattedValue
    extends ExprTy {
        public final ExprTy value;
        public final int conversion;
        public final ExprTy formatSpec;

        public FormattedValue(ExprTy value, int conversion, ExprTy formatSpec, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
            this.conversion = conversion;
            this.formatSpec = formatSpec;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Call
    extends ExprTy {
        public final ExprTy func;
        public final ExprTy[] args;
        public final KeywordTy[] keywords;

        public Call(ExprTy func, ExprTy[] args, KeywordTy[] keywords, SourceRange sourceRange) {
            super(sourceRange);
            assert (func != null);
            this.func = func;
            this.args = args;
            this.keywords = keywords;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Compare
    extends ExprTy {
        public final ExprTy left;
        public final CmpOpTy[] ops;
        public final ExprTy[] comparators;

        public Compare(ExprTy left, CmpOpTy[] ops, ExprTy[] comparators, SourceRange sourceRange) {
            super(sourceRange);
            assert (left != null);
            this.left = left;
            this.ops = ops;
            this.comparators = comparators;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class YieldFrom
    extends ExprTy {
        public final ExprTy value;

        public YieldFrom(ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Yield
    extends ExprTy {
        public final ExprTy value;

        public Yield(ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Await
    extends ExprTy {
        public final ExprTy value;

        public Await(ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class GeneratorExp
    extends ExprTy {
        public final ExprTy element;
        public final ComprehensionTy[] generators;

        public GeneratorExp(ExprTy element, ComprehensionTy[] generators, SourceRange sourceRange) {
            super(sourceRange);
            assert (element != null);
            this.element = element;
            this.generators = generators;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class DictComp
    extends ExprTy {
        public final ExprTy key;
        public final ExprTy value;
        public final ComprehensionTy[] generators;

        public DictComp(ExprTy key, ExprTy value, ComprehensionTy[] generators, SourceRange sourceRange) {
            super(sourceRange);
            assert (key != null);
            this.key = key;
            assert (value != null);
            this.value = value;
            this.generators = generators;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class SetComp
    extends ExprTy {
        public final ExprTy element;
        public final ComprehensionTy[] generators;

        public SetComp(ExprTy element, ComprehensionTy[] generators, SourceRange sourceRange) {
            super(sourceRange);
            assert (element != null);
            this.element = element;
            this.generators = generators;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class ListComp
    extends ExprTy {
        public final ExprTy element;
        public final ComprehensionTy[] generators;

        public ListComp(ExprTy element, ComprehensionTy[] generators, SourceRange sourceRange) {
            super(sourceRange);
            assert (element != null);
            this.element = element;
            this.generators = generators;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Set
    extends ExprTy {
        public final ExprTy[] elements;

        public Set(ExprTy[] elements, SourceRange sourceRange) {
            super(sourceRange);
            this.elements = elements;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Dict
    extends ExprTy {
        public final ExprTy[] keys;
        public final ExprTy[] values;

        public Dict(ExprTy[] keys, ExprTy[] values, SourceRange sourceRange) {
            super(sourceRange);
            this.keys = keys;
            this.values = values;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class IfExp
    extends ExprTy {
        public final ExprTy test;
        public final ExprTy body;
        public final ExprTy orElse;

        public IfExp(ExprTy test, ExprTy body, ExprTy orElse, SourceRange sourceRange) {
            super(sourceRange);
            assert (test != null);
            this.test = test;
            assert (body != null);
            this.body = body;
            assert (orElse != null);
            this.orElse = orElse;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Lambda
    extends ExprTy {
        public final ArgumentsTy args;
        public final ExprTy body;

        public Lambda(ArgumentsTy args, ExprTy body, SourceRange sourceRange) {
            super(sourceRange);
            assert (args != null);
            this.args = args;
            assert (body != null);
            this.body = body;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class UnaryOp
    extends ExprTy {
        public final UnaryOpTy op;
        public final ExprTy operand;

        public UnaryOp(UnaryOpTy op, ExprTy operand, SourceRange sourceRange) {
            super(sourceRange);
            assert (op != null);
            this.op = op;
            assert (operand != null);
            this.operand = operand;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class BinOp
    extends ExprTy {
        public final ExprTy left;
        public final OperatorTy op;
        public final ExprTy right;

        public BinOp(ExprTy left, OperatorTy op, ExprTy right, SourceRange sourceRange) {
            super(sourceRange);
            assert (left != null);
            this.left = left;
            assert (op != null);
            this.op = op;
            assert (right != null);
            this.right = right;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class NamedExpr
    extends ExprTy {
        public final ExprTy target;
        public final ExprTy value;

        public NamedExpr(ExprTy target, ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            assert (target != null);
            this.target = target;
            assert (value != null);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class BoolOp
    extends ExprTy {
        public final BoolOpTy op;
        public final ExprTy[] values;

        public BoolOp(BoolOpTy op, ExprTy[] values, SourceRange sourceRange) {
            super(sourceRange);
            assert (op != null);
            this.op = op;
            this.values = values;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }
}

