/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyNumberAddNode;
import com.oracle.graal.python.lib.PyNumberAndNode;
import com.oracle.graal.python.lib.PyNumberDivmodNode;
import com.oracle.graal.python.lib.PyNumberFloorDivideNode;
import com.oracle.graal.python.lib.PyNumberLshiftNode;
import com.oracle.graal.python.lib.PyNumberMatrixMultiplyNode;
import com.oracle.graal.python.lib.PyNumberMultiplyNode;
import com.oracle.graal.python.lib.PyNumberOrNode;
import com.oracle.graal.python.lib.PyNumberRemainderNode;
import com.oracle.graal.python.lib.PyNumberRshiftNode;
import com.oracle.graal.python.lib.PyNumberSubtractNode;
import com.oracle.graal.python.lib.PyNumberTrueDivideNode;
import com.oracle.graal.python.lib.PyNumberXorNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmeticFactory;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.CallArithmeticRootNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public enum BinaryArithmetic {
    Add(PyNumberAddNode::create),
    Sub(PyNumberSubtractNode::create),
    Mul(PyNumberMultiplyNode::create),
    TrueDiv(PyNumberTrueDivideNode::create),
    FloorDiv(PyNumberFloorDivideNode::create),
    Mod(PyNumberRemainderNode::create),
    LShift(PyNumberLshiftNode::create),
    RShift(PyNumberRshiftNode::create),
    And(PyNumberAndNode::create),
    Or(PyNumberOrNode::create),
    Xor(PyNumberXorNode::create),
    MatMul(PyNumberMatrixMultiplyNode::create),
    Pow(BinaryArithmeticFactory.PowNodeGen::create),
    DivMod(PyNumberDivmodNode::create);

    private final CreateBinaryOp create;

    private BinaryArithmetic(CreateBinaryOp create) {
        this.create = create;
    }

    @NeverDefault
    public BinaryOpNode create() {
        return this.create.create();
    }

    public RootNode createRootNode(PythonLanguage language) {
        return new CallBinaryArithmeticRootNode(language, this);
    }

    static interface CreateBinaryOp {
        public BinaryOpNode create();
    }

    static final class CallBinaryArithmeticRootNode
    extends CallArithmeticRootNode {
        static final Signature SIGNATURE_BINARY = new Signature(2, false, -1, false, PythonUtils.tsArray("$self", "other"), null);
        @Node.Child
        private BinaryOpNode callBinaryNode;
        private final BinaryArithmetic binaryOperator;

        CallBinaryArithmeticRootNode(PythonLanguage language, BinaryArithmetic binaryOperator) {
            super(language);
            this.binaryOperator = binaryOperator;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE_BINARY;
        }

        @Override
        protected Object doCall(VirtualFrame frame) {
            if (this.callBinaryNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callBinaryNode = (BinaryOpNode)this.insert(this.binaryOperator.create());
            }
            return this.callBinaryNode.executeObject(frame, PArguments.getArgument((Frame)frame, 0), PArguments.getArgument((Frame)frame, 1));
        }
    }

    public static abstract class GenericBinaryArithmeticNode
    extends BinaryArithmeticNode {
        private final SpecialMethodSlot slot;

        protected GenericBinaryArithmeticNode(SpecialMethodSlot slot) {
            this.slot = slot;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }

        @NeverDefault
        protected LookupAndCallBinaryNode createCallNode() {
            return LookupAndCallBinaryNode.create(this.slot, GenericBinaryArithmeticNode.createHandler(this.slot.getName().toString()));
        }

        @NeverDefault
        public static GenericBinaryArithmeticNode create(SpecialMethodSlot slot) {
            return BinaryArithmeticFactory.GenericBinaryArithmeticNodeGen.create(slot);
        }
    }

    public static abstract class PowNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = PowNode.createHandler("** or pow()");

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Pow, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class BinaryArithmeticNode
    extends BinaryOpNode {
        static Supplier<LookupAndCallBinaryNode.NotImplementedHandler> createHandler(final String operator) {
            return () -> new LookupAndCallBinaryNode.NotImplementedHandler(){
                @Node.Child
                private PRaiseNode raiseNode = PRaiseNode.create();

                @Override
                public Object execute(VirtualFrame frame, Object arg, Object arg2) {
                    throw this.raiseNode.raise(PythonErrorType.TypeError, this.getErrorMessage(arg), operator, arg, arg2);
                }

                @CompilerDirectives.TruffleBoundary
                private TruffleString getErrorMessage(Object arg) {
                    if (operator.equals(">>") && arg instanceof PBuiltinMethod && ((PBuiltinMethod)arg).getBuiltinFunction().getName().equalsUncached((AbstractTruffleString)BuiltinNames.T_PRINT, PythonUtils.TS_ENCODING)) {
                        return ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P_PRINT;
                    }
                    return ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P;
                }
            };
        }

        @NeverDefault
        public static LookupAndCallBinaryNode createCallNode(SpecialMethodSlot slot, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            assert (slot.getReverse() != null);
            return LookupAndCallBinaryNode.createReversible(slot, slot.getReverse(), handler);
        }
    }
}

