/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.nodes.call.InvokeNode;
import com.oracle.truffle.api.CompilerDirectives;

abstract class DirectInvokeNode
extends InvokeNode {
    @CompilerDirectives.CompilationFinal
    private int state = 0;

    DirectInvokeNode() {
    }

    protected boolean profileIsNullFrame(boolean isNullFrame) {
        if (this.state == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.state = isNullFrame ? 1 : 2;
        }
        if (this.state == 1) {
            if (!isNullFrame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("Invoke node was initialized for a null frame. Cannot use it with non-null frame now.");
            }
            return true;
        }
        assert (this.state == 2);
        if (isNullFrame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("Invoke node was initialized for a non-null frame. Cannot use it with null frame now.");
        }
        return false;
    }
}

