/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.call.CallTargetInvokeNodeGen;
import com.oracle.graal.python.nodes.call.DirectInvokeNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class CallTargetInvokeNode
extends DirectInvokeNode {
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private ExecutionContext.CallContext callContext;
    protected final boolean isBuiltin;

    protected CallTargetInvokeNode(CallTarget callTarget, boolean isBuiltin, boolean isGenerator) {
        this.callNode = Truffle.getRuntime().createDirectCallNode(callTarget);
        if (isBuiltin) {
            this.callNode.cloneCallTarget();
        }
        if (isGenerator && CallTargetInvokeNode.shouldInlineGenerators()) {
            this.callNode.forceInlining();
        }
        this.callContext = ExecutionContext.CallContext.create();
        this.isBuiltin = isBuiltin;
    }

    @CompilerDirectives.TruffleBoundary
    public static CallTargetInvokeNode create(PFunction callee) {
        RootCallTarget callTarget = CallTargetInvokeNode.getCallTarget(callee);
        boolean builtin = CallTargetInvokeNode.isBuiltin(callee);
        boolean isGenerator = callTarget.getRootNode() instanceof PBytecodeGeneratorFunctionRootNode;
        return CallTargetInvokeNodeGen.create((CallTarget)callTarget, builtin, isGenerator);
    }

    @CompilerDirectives.TruffleBoundary
    public static CallTargetInvokeNode create(PBuiltinFunction callee) {
        RootCallTarget callTarget = CallTargetInvokeNode.getCallTarget(callee);
        boolean builtin = CallTargetInvokeNode.isBuiltin(callee);
        return CallTargetInvokeNodeGen.create((CallTarget)callTarget, builtin, false);
    }

    public static CallTargetInvokeNode create(CallTarget callTarget, boolean isBuiltin, boolean isGenerator) {
        return CallTargetInvokeNodeGen.create(callTarget, isBuiltin, isGenerator);
    }

    public abstract Object execute(VirtualFrame var1, PFunction var2, PythonObject var3, PCell[] var4, Object[] var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"globals == null", "closure == null"})
    protected Object doNoClosure(VirtualFrame frame, PFunction callee, PythonObject globals, PCell[] closure, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile generatorFunctionProfile) {
        RootCallTarget ct = (RootCallTarget)this.callNode.getCurrentCallTarget();
        CallTargetInvokeNode.optionallySetGeneratorFunction(inliningTarget, arguments, (CallTarget)ct, generatorFunctionProfile, callee);
        if (this.profileIsNullFrame(frame == null)) {
            PythonContext.PythonThreadState threadState = PythonContext.get(this).getThreadState(PythonLanguage.get(this));
            Object state = ExecutionContext.IndirectCalleeContext.enter(threadState, arguments, ct);
            try {
                Object object = this.callNode.call(arguments);
                return object;
            }
            finally {
                ExecutionContext.IndirectCalleeContext.exit(threadState, state);
            }
        }
        this.callContext.prepareCall(frame, arguments, ct, this);
        return this.callNode.call(arguments);
    }

    @Specialization(replaces={"doNoClosure"})
    protected Object doGeneric(VirtualFrame frame, PFunction callee, PythonObject globals, PCell[] closure, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile generatorFunctionProfile) {
        PArguments.setGlobals(arguments, globals);
        PArguments.setClosure(arguments, closure);
        return this.doNoClosure(frame, callee, null, null, arguments, inliningTarget, generatorFunctionProfile);
    }

    public final CallTarget getCallTarget() {
        return this.callNode.getCallTarget();
    }

    public final RootNode getCurrentRootNode() {
        return this.callNode.getCurrentRootNode();
    }
}

