/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNode;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallDispatchNode;
import com.oracle.graal.python.nodes.call.CallNodeGen;
import com.oracle.graal.python.nodes.call.ForeignMethod;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@TypeSystemReference(value=PythonTypes.class)
@ImportStatic(value={PGuards.class, SpecialMethodNames.class})
@GenerateUncached
public abstract class CallNode
extends PNodeWithContext {
    @NeverDefault
    public static CallNode create() {
        return CallNodeGen.create();
    }

    public static CallNode getUncached() {
        return CallNodeGen.getUncached();
    }

    protected abstract Object executeInternal(Frame var1, Object var2, Object[] var3, PKeyword[] var4);

    public final Object executeWithoutFrame(Object callableObject, Object[] arguments, PKeyword[] keywords) {
        return this.executeInternal(null, callableObject, arguments, keywords);
    }

    public static Object executeUncached(Object callableObject, Object[] arguments, PKeyword[] keywords) {
        return CallNode.getUncached().executeInternal(null, callableObject, arguments, keywords);
    }

    public final Object executeWithoutFrame(Object callableObject, Object ... arguments) {
        return this.executeInternal(null, callableObject, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    public static Object executeUncached(Object callableObject, Object ... arguments) {
        return CallNode.getUncached().executeInternal(null, callableObject, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    public final Object execute(Frame frame, Object callableObject, Object[] arguments, PKeyword[] keywords) {
        return this.executeInternal(frame, callableObject, arguments, keywords);
    }

    public final Object execute(Frame frame, Object callableObject, Object ... arguments) {
        return this.executeInternal(frame, callableObject, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    @Specialization
    protected static Object boundDescriptor(VirtualFrame frame, BoundDescriptor descriptor, Object[] arguments, PKeyword[] keywords, @Cached CallNode subNode) {
        return subNode.executeInternal((Frame)frame, descriptor.descriptor, PythonUtils.arrayCopyOfRange(arguments, 1, arguments.length), keywords);
    }

    @Specialization
    protected static Object functionCall(VirtualFrame frame, PFunction callable, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="dispatchNode") @Cached CallDispatchNode dispatch, @Cached.Shared(value="argsNode") @Cached CreateArgumentsNode createArgs) {
        return dispatch.executeCall(frame, callable, createArgs.execute(callable, arguments, keywords));
    }

    @Specialization
    protected static Object builtinFunctionCall(VirtualFrame frame, PBuiltinFunction callable, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="dispatchNode") @Cached CallDispatchNode dispatch, @Cached.Shared(value="argsNode") @Cached CreateArgumentsNode createArgs) {
        return dispatch.executeCall(frame, callable, createArgs.execute(callable, arguments, keywords));
    }

    @Specialization
    protected static Object doType(VirtualFrame frame, PythonBuiltinClassType callableObject, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupCall") @Cached(parameters={"Call"}) LookupSpecialMethodSlotNode lookupCall, @Cached.Shared(value="callCall") @Cached CallVarargsMethodNode callCallNode) {
        Object call = lookupCall.execute((Frame)frame, getClassNode.execute(inliningTarget, (Object)callableObject), (Object)callableObject);
        return CallNode.callCall(frame, (Object)callableObject, arguments, keywords, raise, callCallNode, call);
    }

    @Specialization(guards={"isPythonClass(callableObject)"}, replaces={"doType"})
    protected static Object doPythonClass(VirtualFrame frame, Object callableObject, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupCall") @Cached(parameters={"Call"}) LookupSpecialMethodSlotNode lookupCall, @Cached.Shared(value="callCall") @Cached CallVarargsMethodNode callCallNode) {
        Object call = lookupCall.execute((Frame)frame, getClassNode.execute(inliningTarget, callableObject), callableObject);
        return CallNode.callCall(frame, callableObject, arguments, keywords, raise, callCallNode, call);
    }

    @Specialization(guards={"!isCallable(callableObject)", "!isForeignMethod(callableObject)"}, replaces={"doType", "doPythonClass"})
    protected static Object doObjectAndType(VirtualFrame frame, Object callableObject, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupCall") @Cached(parameters={"Call"}) LookupSpecialMethodSlotNode lookupCall, @Cached.Shared(value="callCall") @Cached CallVarargsMethodNode callCallNode) {
        Object call = lookupCall.execute((Frame)frame, getClassNode.execute(inliningTarget, callableObject), callableObject);
        return CallNode.callCall(frame, callableObject, arguments, keywords, raise, callCallNode, call);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    protected static Object doForeignMethod(ForeignMethod callable, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached PForeignToPTypeNode fromForeign, @Cached InlinedBranchProfile keywordsError, @Cached InlinedBranchProfile typeError, @Cached GilNode gil, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop) {
        if (keywords.length != 0) {
            keywordsError.enter(inliningTarget);
            throw raise.raise(PythonErrorType.TypeError, ErrorMessages.INVALID_INSTANTIATION_OF_FOREIGN_OBJ);
        }
        gil.release(true);
        try {
            Object object = fromForeign.executeConvert(interop.invokeMember(callable.receiver, callable.methodName, arguments));
            return object;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            typeError.enter(inliningTarget);
            throw raise.raise(PythonBuiltinClassType.TypeError, (Exception)e);
        }
        catch (UnknownIdentifierException e) {
            throw CompilerDirectives.shouldNotReachHere((String)"Cannot invoke member");
        }
        finally {
            gil.acquire();
        }
    }

    private static Object callCall(VirtualFrame frame, Object callableObject, Object[] arguments, PKeyword[] keywords, PRaiseNode raise, CallVarargsMethodNode callCallNode, Object call) {
        if (call == PNone.NO_VALUE) {
            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_ISNT_CALLABLE, callableObject);
        }
        return callCallNode.execute((Frame)frame, call, PythonUtils.prependArgument(callableObject, arguments), keywords);
    }

    @Specialization(guards={"isPBuiltinFunction(callable.getFunction())"})
    protected static Object methodCallBuiltinDirect(VirtualFrame frame, PMethod callable, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="dispatchNode") @Cached CallDispatchNode dispatch, @Cached.Shared(value="argsNode") @Cached CreateArgumentsNode createArgs) {
        return dispatch.executeCall(frame, (PBuiltinFunction)callable.getFunction(), createArgs.execute(callable, arguments, keywords));
    }

    @Specialization(guards={"isPFunction(callable.getFunction())"}, replaces={"methodCallBuiltinDirect"})
    protected static Object methodCallDirect(VirtualFrame frame, PMethod callable, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="dispatchNode") @Cached CallDispatchNode dispatch, @Cached.Shared(value="argsNode") @Cached CreateArgumentsNode createArgs) {
        return dispatch.executeCall(frame, (PFunction)callable.getFunction(), createArgs.execute(callable, arguments, keywords));
    }

    @Specialization(limit="1", guards={"isSingleContext()", "callable == cachedCallable", "isPBuiltinFunction(cachedCallable.getFunction())"})
    protected static Object builtinMethodCallBuiltinDirectCached(VirtualFrame frame, PBuiltinMethod callable, Object[] arguments, PKeyword[] keywords, @Cached(value="callable", weak=true) PBuiltinMethod cachedCallable, @Cached.Shared(value="dispatchNode") @Cached CallDispatchNode dispatch, @Cached.Shared(value="argsNode") @Cached CreateArgumentsNode createArgs) {
        return dispatch.executeCall(frame, cachedCallable.getBuiltinFunction(), createArgs.execute(cachedCallable, arguments, keywords));
    }

    @Specialization(guards={"isPBuiltinFunction(callable.getFunction())"}, replaces={"builtinMethodCallBuiltinDirectCached"})
    protected static Object builtinMethodCallBuiltinDirect(VirtualFrame frame, PBuiltinMethod callable, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="dispatchNode") @Cached CallDispatchNode dispatch, @Cached.Shared(value="argsNode") @Cached CreateArgumentsNode createArgs) {
        return dispatch.executeCall(frame, callable.getBuiltinFunction(), createArgs.execute(callable, arguments, keywords));
    }

    @Specialization(guards={"!isFunction(callable.getFunction())"})
    protected static Object methodCall(VirtualFrame frame, PMethod callable, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupCall") @Cached(parameters={"Call"}) LookupSpecialMethodSlotNode lookupCall, @Cached.Shared(value="callCall") @Cached CallVarargsMethodNode callCallNode) {
        return CallNode.doObjectAndType(frame, callable, arguments, keywords, inliningTarget, raise, getClassNode, lookupCall, callCallNode);
    }

    @Specialization(guards={"!isFunction(callable.getFunction())"})
    protected static Object builtinMethodCall(VirtualFrame frame, PBuiltinMethod callable, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupCall") @Cached(parameters={"Call"}) LookupSpecialMethodSlotNode lookupCall, @Cached.Shared(value="callVarargs") @Cached CallVarargsMethodNode callCallNode) {
        return CallNode.doObjectAndType(frame, callable, arguments, keywords, inliningTarget, raise, getClassNode, lookupCall, callCallNode);
    }

    @Specialization(replaces={"doObjectAndType", "methodCallBuiltinDirect", "methodCallDirect", "builtinMethodCallBuiltinDirectCached", "builtinMethodCallBuiltinDirect", "methodCall", "builtinMethodCall", "functionCall", "builtinFunctionCall"}, guards={"!isForeignMethod(callableObject)"})
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    protected static Object doGeneric(VirtualFrame frame, Object callableObject, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="dispatchNode") @Cached CallDispatchNode dispatch, @Cached.Shared(value="argsNode") @Cached CreateArgumentsNode createArgs, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupCall") @Cached(parameters={"Call"}) LookupSpecialMethodSlotNode lookupCall, @Cached.Shared(value="callVarargs") @Cached CallVarargsMethodNode callCallNode) {
        if (callableObject instanceof PFunction) {
            return CallNode.functionCall(frame, (PFunction)callableObject, arguments, keywords, dispatch, createArgs);
        }
        if (callableObject instanceof PBuiltinFunction) {
            return CallNode.builtinFunctionCall(frame, (PBuiltinFunction)callableObject, arguments, keywords, dispatch, createArgs);
        }
        if (callableObject instanceof PMethod) {
            PMethod method = (PMethod)callableObject;
            Object func = method.getFunction();
            if (func instanceof PFunction) {
                return CallNode.methodCallDirect(frame, method, arguments, keywords, dispatch, createArgs);
            }
            if (func instanceof PBuiltinFunction) {
                return CallNode.methodCallBuiltinDirect(frame, method, arguments, keywords, dispatch, createArgs);
            }
        } else {
            if (callableObject instanceof PBuiltinMethod) {
                PBuiltinMethod method = (PBuiltinMethod)callableObject;
                return CallNode.builtinMethodCallBuiltinDirect(frame, method, arguments, keywords, dispatch, createArgs);
            }
            if (callableObject instanceof BoundDescriptor) {
                return CallNode.doGeneric(frame, ((BoundDescriptor)callableObject).descriptor, PythonUtils.arrayCopyOfRange(arguments, 1, arguments.length), keywords, inliningTarget, dispatch, createArgs, raise, getClassNode, lookupCall, callCallNode);
            }
        }
        Object callableType = getClassNode.execute(inliningTarget, callableObject);
        return CallNode.callCall(frame, callableObject, arguments, keywords, raise, callCallNode, lookupCall.execute((Frame)frame, callableType, callableObject));
    }

    protected static boolean isForeignMethod(Object object) {
        return object instanceof ForeignMethod;
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class Lazy
    extends Node {
        public final CallNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        abstract CallNode execute(Node var1);

        @Specialization
        protected static CallNode doIt(@Cached(inline=false) CallNode callNode) {
            return callNode;
        }
    }
}

