/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.GetEscapedExceptionNode;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.StopIterationBuiltins;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.bytecode.ThrowNodeGen;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline(value=false)
public abstract class ThrowNode
extends PNodeWithContext {
    private static final TruffleString T_CLOSE = PythonUtils.tsLiteral("close");
    private static final TruffleString T_THROW = PythonUtils.tsLiteral("throw");

    public abstract boolean execute(VirtualFrame var1, int var2, Object var3, AbstractTruffleException var4);

    @Specialization
    static boolean doGenerator(VirtualFrame frame, int stackTop, PGenerator generator, AbstractTruffleException exception, @Bind(value="this") Node inliningTarget, @Cached CommonGeneratorBuiltins.ThrowNode throwNode, @Cached CommonGeneratorBuiltins.CloseNode closeNode, @Cached.Exclusive @Cached GetEscapedExceptionNode getEscapedExceptionNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileExit, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        Object exceptionObject = getEscapedExceptionNode.execute(inliningTarget, exception);
        if (profileExit.profileObject(inliningTarget, exceptionObject, PythonBuiltinClassType.GeneratorExit)) {
            closeNode.execute(frame, generator);
            throw exception;
        }
        try {
            Object value = throwNode.execute(frame, generator, exceptionObject, PNone.NO_VALUE, PNone.NO_VALUE);
            frame.setObject(stackTop, value);
            return false;
        }
        catch (PException e) {
            ThrowNode.handleException(frame, inliningTarget, e, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    @Fallback
    static boolean doOther(VirtualFrame frame, int stackTop, Object obj, AbstractTruffleException exception, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupThrow, @Cached PyObjectLookupAttr lookupClose, @Cached CallNode callThrow, @Cached CallNode callClose, @Cached WriteUnraisableNode writeUnraisableNode, @Cached GetClassNode getClassNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached.Exclusive @Cached GetEscapedExceptionNode getEscapedExceptionNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileExit, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        Object exceptionObject = getEscapedExceptionNode.execute(inliningTarget, exception);
        if (profileExit.profileObject(inliningTarget, exceptionObject, PythonBuiltinClassType.GeneratorExit)) {
            Object close = PNone.NO_VALUE;
            try {
                close = lookupClose.execute((Frame)frame, inliningTarget, obj, T_CLOSE);
            }
            catch (PException e) {
                writeUnraisableNode.execute(frame, e.getEscapedException(), null, obj);
            }
            if (close != PNone.NO_VALUE) {
                callClose.execute((Frame)frame, close, new Object[0]);
            }
            throw exception;
        }
        Object throwMethod = lookupThrow.execute((Frame)frame, inliningTarget, obj, T_THROW);
        if (throwMethod == PNone.NO_VALUE) {
            throw exception;
        }
        try {
            Object type = getClassNode.execute(inliningTarget, exceptionObject);
            Object tb = getTracebackNode.execute(inliningTarget, exceptionObject);
            Object value = callThrow.execute((Frame)frame, throwMethod, type, exceptionObject, tb);
            frame.setObject(stackTop, value);
            return false;
        }
        catch (PException e) {
            ThrowNode.handleException(frame, inliningTarget, e, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    private static void handleException(VirtualFrame frame, Node inliningTarget, PException e, BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, StopIterationBuiltins.StopIterationValueNode getValue, int stackTop) {
        e.expectStopIteration(inliningTarget, stopIterationProfile);
        Object value = getValue.execute((PBaseException)e.getUnreifiedException());
        frame.setObject(stackTop, null);
        frame.setObject(stackTop - 1, value);
    }

    public static ThrowNode create() {
        return ThrowNodeGen.create();
    }
}

