/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.SlotMethodDef;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;

public abstract class LookupNativeSlotNode
extends PNodeWithContext {
    private LookupNativeSlotNode() {
    }

    @CompilerDirectives.TruffleBoundary
    public static Object executeUncached(PythonManagedClass klass, SlotMethodDef slot) {
        MroSequenceStorage mro = TypeNodes.GetMroStorageNode.getUncached().execute(null, klass);
        ReadAttributeFromObjectNode readAttrNode = ReadAttributeFromObjectNode.getUncachedForceType();
        CStructAccess.ReadPointerNode readPointerNode = CStructAccess.ReadPointerNode.getUncached();
        InteropLibrary interopLibrary = InteropLibrary.getUncached();
        SlotMethodDef overlappingSlot = slot.overlappingSlot;
        Object foundNativeSlotOverlap = null;
        for (int i = 0; i < mro.length(); ++i) {
            PythonAbstractClass kls = mro.getPythonClassItemNormalized(i);
            Object value = LookupNativeSlotNode.readSlot(slot, kls, readAttrNode, readPointerNode, interopLibrary);
            if (value != null) {
                if (foundNativeSlotOverlap != null && kls instanceof PythonManagedClass) {
                    return foundNativeSlotOverlap;
                }
                return value;
            }
            if (overlappingSlot == null || foundNativeSlotOverlap != null || !(kls instanceof PythonAbstractNativeObject)) continue;
            PythonAbstractNativeObject nativeObject = (PythonAbstractNativeObject)kls;
            foundNativeSlotOverlap = LookupNativeSlotNode.readSlot(overlappingSlot, kls, readAttrNode, readPointerNode, interopLibrary);
        }
        if (foundNativeSlotOverlap != null) {
            return foundNativeSlotOverlap;
        }
        return LookupNativeSlotNode.getNULL();
    }

    private static Object getNULL() {
        return PythonContext.get(null).getNativeNull();
    }

    private static Object readSlot(SlotMethodDef slot, PythonAbstractClass currentType, ReadAttributeFromObjectNode readNode, CStructAccess.ReadPointerNode readPointerNode, InteropLibrary interopLibrary) {
        if (currentType instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject nativeObject = (PythonAbstractNativeObject)currentType;
            Object value = readPointerNode.readFromObj(nativeObject, slot.typeField);
            if (!PGuards.isNullOrZero(value, interopLibrary)) {
                if (slot.methodsField == null) {
                    return value;
                }
                if (!PGuards.isNullOrZero(value = readPointerNode.read(value, slot.methodsField), interopLibrary)) {
                    return value;
                }
            }
        } else {
            PythonBuiltinClass builtinClass;
            assert (currentType instanceof PythonManagedClass);
            if (slot.methodFlag != 0L && currentType instanceof PythonBuiltinClass && ((builtinClass = (PythonBuiltinClass)currentType).getType().getMethodsFlags() & slot.methodFlag) == 0L) {
                return null;
            }
            Object value = readNode.execute(currentType, slot.methodName);
            if (value != PNone.NO_VALUE) {
                if (slot == SlotMethodDef.TP_HASH && value == PNone.NONE) {
                    return CApiContext.getNativeSymbol(null, NativeCAPISymbol.FUN_PYOBJECT_HASH_NOT_IMPLEMENTED);
                }
                return LookupNativeSlotNode.wrapManagedMethod(slot, (PythonManagedClass)currentType, value);
            }
        }
        return null;
    }

    private static Object wrapManagedMethod(SlotMethodDef slot, PythonManagedClass owner, Object value) {
        if (value instanceof PNone) {
            return LookupNativeSlotNode.getNULL();
        }
        return PythonContext.get(null).getCApiContext().getOrCreateProcWrapper(owner, slot, () -> (PyProcsWrapper)slot.wrapperFactory.apply(value));
    }

    public boolean isAdoptable() {
        return false;
    }
}

