/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;

public abstract class PRootNode
extends RootNode {
    private final ConditionProfile frameEscaped = ConditionProfile.create();
    @CompilerDirectives.CompilationFinal
    private Assumption dontNeedCallerFrame = PRootNode.createCallerFrameAssumption();
    @CompilerDirectives.CompilationFinal
    private Assumption dontNeedExceptionState = PRootNode.createExceptionStateAssumption();
    private int nodeCount = -1;
    private byte[] code;

    protected PRootNode(TruffleLanguage<?> language) {
        super(language);
    }

    protected PRootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor) {
        super(language, frameDescriptor);
    }

    public final int getNodeCountForInlining() {
        CompilerAsserts.neverPartOfCompilation();
        int n = this.nodeCount;
        if (n != -1) {
            return n;
        }
        int maxSize = PythonLanguage.get((Node)this).getEngineOption(PythonOptions.BuiltinsInliningMaxCallerSize);
        PythonUtils.NodeCounterWithLimit counter = new PythonUtils.NodeCounterWithLimit(maxSize);
        this.accept(counter);
        this.nodeCount = counter.getCount();
        return this.nodeCount;
    }

    public final void setNodeCountForInlining(int newCount) {
        assert (newCount > 0 && newCount <= PythonLanguage.get((Node)this).getEngineOption(PythonOptions.BuiltinsInliningMaxCallerSize));
        this.nodeCount = newCount;
    }

    public ConditionProfile getFrameEscapedProfile() {
        return this.frameEscaped;
    }

    public boolean needsCallerFrame() {
        return !this.dontNeedCallerFrame.isValid();
    }

    public void setNeedsCallerFrame() {
        CompilerAsserts.neverPartOfCompilation((String)"this is usually called from behind a TruffleBoundary");
        this.dontNeedCallerFrame.invalidate();
    }

    public boolean needsExceptionState() {
        return !this.dontNeedExceptionState.isValid();
    }

    public void setNeedsExceptionState() {
        CompilerAsserts.neverPartOfCompilation((String)"this is usually called from behind a TruffleBoundary");
        this.dontNeedExceptionState.invalidate();
    }

    public boolean isCaptureFramesForTrace(boolean compiledFrame) {
        return true;
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public Node copy() {
        PRootNode pRootNode = (PRootNode)super.copy();
        pRootNode.dontNeedCallerFrame = PRootNode.createCallerFrameAssumption();
        pRootNode.dontNeedExceptionState = PRootNode.createExceptionStateAssumption();
        return pRootNode;
    }

    public abstract Signature getSignature();

    public abstract boolean isPythonInternal();

    @CompilerDirectives.TruffleBoundary
    private static boolean isPythonInternal(PRootNode rootNode) {
        return rootNode.isPythonInternal();
    }

    public static boolean isPythonInternal(RootNode rootNode) {
        return rootNode instanceof PRootNode && PRootNode.isPythonInternal((PRootNode)rootNode);
    }

    public static boolean isPythonBuiltin(RootNode rootNode) {
        return rootNode instanceof BuiltinFunctionRootNode;
    }

    private static Assumption createCallerFrameAssumption() {
        return Truffle.getRuntime().createAssumption("does not need caller frame");
    }

    private static Assumption createExceptionStateAssumption() {
        return Truffle.getRuntime().createAssumption("does not need exception state");
    }

    public final void setCode(byte[] data) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.code == null);
        this.code = data;
    }

    @CompilerDirectives.TruffleBoundary
    public final byte[] getCode() {
        if (this.code != null) {
            return this.code;
        }
        this.code = this.extractCode();
        return this.code;
    }

    protected byte[] extractCode() {
        return PythonUtils.EMPTY_BYTE_ARRAY;
    }

    public boolean setsUpCalleeContext() {
        return false;
    }
}

