/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNodeGen;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyObjectStrAsTruffleStringNode
extends PNodeWithContext {
    public static TruffleString executeUncached(Object object) {
        return PyObjectStrAsTruffleStringNodeGen.getUncached().execute(null, null, object);
    }

    public abstract TruffleString execute(Frame var1, Node var2, Object var3);

    @Specialization
    static TruffleString doString(TruffleString obj) {
        return obj;
    }

    @Specialization
    public static TruffleString doGeneric(VirtualFrame frame, Node inliningTarget, Object obj, @Cached PyObjectStrAsObjectNode strNode, @Cached CastToTruffleStringNode castToString) {
        try {
            return castToString.execute(inliningTarget, strNode.execute((Frame)frame, inliningTarget, obj));
        }
        catch (CannotCastException e) {
            throw CompilerDirectives.shouldNotReachHere((String)"PyObjectStrAsObjectNode result not convertible to string");
        }
    }

    public static PyObjectStrAsTruffleStringNode getUncached() {
        return PyObjectStrAsTruffleStringNodeGen.getUncached();
    }
}

