/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonBuiltinClass
extends PythonManagedClass {
    private final PythonBuiltinClassType type;

    @CompilerDirectives.TruffleBoundary
    public PythonBuiltinClass(PythonLanguage lang, PythonBuiltinClassType builtinClass, PythonAbstractClass base) {
        super(lang, (Object)builtinClass.getType(), builtinClass.getType().getInstanceShape(lang), builtinClass.getInstanceShape(lang), builtinClass.getName(), base, new PythonAbstractClass[]{base}, builtinClass.getSlots());
        this.type = builtinClass;
        this.methodsFlags = this.type.getMethodsFlags();
    }

    @Override
    public void setAttribute(TruffleString name, Object value) {
        CompilerAsserts.neverPartOfCompilation();
        if (PythonContext.get(null).isCoreInitialized()) {
            throw PRaiseNode.raiseUncached(null, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, PyObjectReprAsTruffleStringNode.executeUncached(name), this);
        }
        this.setAttributeUnsafe(name, value);
    }

    public void setAttributeUnsafe(TruffleString name, Object value) {
        super.setAttribute(name, value);
    }

    public PythonBuiltinClassType getType() {
        return this.type;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void onAttributeUpdate(TruffleString key, Object newValue) {
        assert (!PythonContext.get(null).isCoreInitialized());
        assert (!this.getMethodResolutionOrder().invalidateAttributeInMROFinalAssumptions(key));
        assert (PythonBuiltinClass.checkSpecialMethodUpdate(key, newValue));
        SpecialMethodSlot slot = SpecialMethodSlot.findSpecialSlotUncached(key);
        if (slot != null) {
            SpecialMethodSlot.fixupSpecialMethodSlot(this, slot, newValue);
        }
        assert (newValue != PNone.NO_VALUE);
        PythonClass.updateMroShapeSubTypes(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkSpecialMethodUpdate(TruffleString key, Object newValue) {
        if ($assertionsDisabled) return true;
        if (!TpSlots.isSpecialMethod(key)) return true;
        if (newValue instanceof PBuiltinFunction) {
            PBuiltinFunction pBuiltinFunction = (PBuiltinFunction)newValue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        throw new AssertionError();
    }

    @ExportMessage(library=InteropLibrary.class)
    boolean isMetaObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    boolean isMetaInstance(Object instance, @Bind(value="$node") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached.Shared(value="convert") @Cached PForeignToPTypeNode convert, @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isSubtype.execute(getClassNode.execute(inliningTarget, convert.executeConvert(instance)), this);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    String getMetaSimpleName(@Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        boolean mustRelease = gil.acquire();
        try {
            String string = toJavaStringNode.execute((AbstractTruffleString)this.type.getName());
            return string;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    String getMetaQualifiedName(@Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        boolean mustRelease = gil.acquire();
        try {
            String string = toJavaStringNode.execute((AbstractTruffleString)this.type.getPrintName());
            return string;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    @ImportStatic(value={PGuards.class})
    static class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doPBCT(PythonBuiltinClass self, PythonBuiltinClassType other) {
            return self.getType() == other ? TriState.TRUE : TriState.FALSE;
        }

        @Specialization(guards={"!isPythonBuiltinClassType(other)"})
        static TriState doOther(PythonBuiltinClass self, Object other, @Cached.Shared(value="convert") @Cached PForeignToPTypeNode convert, @CachedLibrary(limit="3") InteropLibrary otherLib, @Cached IsNode isNode, @Cached.Exclusive @Cached GilNode gil) {
            return self.isIdenticalOrUndefined(other, convert, otherLib, isNode, gil);
        }
    }
}

