/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.PTupleGetter;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.TupleGetterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.TupleGetterBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTupleGetter})
public final class TupleGetterBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TupleGetterBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TupleGetterBuiltinsFactory.getFactories();
    }

    @Builtin(name="__doc__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class TupleGetterDocNode
    extends PythonBinaryBuiltinNode {
        TupleGetterDocNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object set(PTupleGetter self, Object value) {
            self.setDoc(value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(value)"})
        Object get(PTupleGetter self, PNone value) {
            return self.getDoc();
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_set, isComplex=true)
    @GenerateNodeFactory
    static abstract class DescrSet
    extends TpSlotDescrSet.DescrSetBuiltinNode {
        DescrSet() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        void set(PTupleGetter self, Object instance, Object value) {
            if (PGuards.isNoValue(value)) {
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.AttributeError, ErrorMessages.CANT_DELETE_ATTRIBUTE);
            }
            throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.AttributeError, ErrorMessages.CANT_SET_ATTRIBUTE);
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get, isComplex=true)
    @GenerateNodeFactory
    static abstract class TupleGetterGetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        TupleGetterGetNode() {
        }

        @Specialization
        static Object getTuple(VirtualFrame frame, PTupleGetter self, PTuple instance, Object owner, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached PRaiseNode.Lazy raiseNode) {
            int index = self.getIndex();
            if (index >= sizeNode.execute((Frame)frame, inliningTarget, instance)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.TUPLE_OUT_OF_BOUNDS);
            }
            return getItemNode.execute(frame, instance, index);
        }

        @Specialization
        static Object getNone(VirtualFrame frame, PTupleGetter self, PNone instance, Object owner) {
            return self;
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static Object getOthers(VirtualFrame frame, Object self, Object instance, Object owner, @Cached PRaiseNode raiseNode) {
            int index = ((PTupleGetter)self).getIndex();
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DESC_FOR_INDEX_S_FOR_S_DOESNT_APPLY_TO_P, index, "tuple subclasses", instance);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PTupleGetter self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            PTuple args = factory.createTuple(new Object[]{self.getIndex(), self.getDoc()});
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), args});
        }
    }
}

