/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.str;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.NativeCharSequence;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodesFactory;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;

public abstract class StringNodes {

    @GenerateUncached
    public static abstract class StringReprNode
    extends Node {
        public abstract TruffleString execute(TruffleString var1);

        @Specialization
        static TruffleString doString(TruffleString self, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            int selfLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            boolean hasSingleQuote = indexOfCodePointNode.execute((AbstractTruffleString)self, 39, 0, selfLen, PythonUtils.TS_ENCODING) >= 0;
            boolean hasDoubleQuote = indexOfCodePointNode.execute((AbstractTruffleString)self, 34, 0, selfLen, PythonUtils.TS_ENCODING) >= 0;
            boolean useDoubleQuotes = hasSingleQuote && !hasDoubleQuote;
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)PythonUtils.tsbCapacity(selfLen + 2));
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            byte[] buffer = new byte[12];
            appendCodePointNode.execute(sb, useDoubleQuotes ? 34 : 39, 1, true);
            block5: while (it.hasNext()) {
                int codepoint = nextNode.execute(it);
                switch (codepoint) {
                    case 34: {
                        if (useDoubleQuotes) {
                            appendCodePointNode.execute(sb, 92, 1, true);
                        }
                        appendCodePointNode.execute(sb, 34, 1, true);
                        continue block5;
                    }
                    case 39: {
                        if (!useDoubleQuotes) {
                            appendCodePointNode.execute(sb, 92, 1, true);
                        }
                        appendCodePointNode.execute(sb, 39, 1, true);
                        continue block5;
                    }
                    case 92: {
                        appendCodePointNode.execute(sb, 92, 1, true);
                        appendCodePointNode.execute(sb, 92, 1, true);
                        continue block5;
                    }
                }
                if (StringUtils.isPrintable(codepoint)) {
                    appendCodePointNode.execute(sb, codepoint, 1, true);
                    continue;
                }
                int len = BytesUtils.unicodeEscape(codepoint, 0, buffer);
                for (int i = 0; i < len; ++i) {
                    appendCodePointNode.execute(sb, (int)buffer[i], 1, true);
                }
            }
            appendCodePointNode.execute(sb, (int)((byte)(useDoubleQuotes ? 34 : 39)), 1, true);
            return toStringNode.execute(sb);
        }

        public static StringReprNode getUncached() {
            return StringNodesFactory.StringReprNodeGen.getUncached();
        }
    }

    @GenerateUncached
    public static abstract class StringReplaceNode
    extends Node {
        public abstract TruffleString execute(TruffleString var1, TruffleString var2, TruffleString var3, int var4);

        @Specialization
        static TruffleString doReplace(TruffleString self, TruffleString old, TruffleString with, int maxCountArg, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            int maxCount;
            int n = maxCount = maxCountArg < 0 ? Integer.MAX_VALUE : maxCountArg;
            if (maxCount == 0) {
                return self;
            }
            if (old.isEmpty()) {
                if (self.isEmpty() && maxCountArg >= 0) {
                    return with;
                }
                int selfLen = self.byteLength(PythonUtils.TS_ENCODING);
                int selfCpLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(selfLen + with.byteLength(PythonUtils.TS_ENCODING) * Math.min(maxCount, selfCpLen + 1)));
                int replacements = 0;
                TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
                int i = 0;
                while (it.hasNext()) {
                    if (replacements++ >= maxCount) {
                        TruffleString rest = substringNode.execute((AbstractTruffleString)self, i, selfCpLen - i, PythonUtils.TS_ENCODING, true);
                        appendStringNode.execute(sb, (AbstractTruffleString)rest);
                        return toStringNode.execute(sb);
                    }
                    appendStringNode.execute(sb, (AbstractTruffleString)with);
                    int codePoint = nextNode.execute(it);
                    appendCodePointNode.execute(sb, codePoint, 1, true);
                    ++i;
                }
                if (replacements < maxCount) {
                    appendStringNode.execute(sb, (AbstractTruffleString)with);
                }
                return toStringNode.execute(sb);
            }
            int selfCpLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            int oldCpLen = codePointLengthNode.execute((AbstractTruffleString)old, PythonUtils.TS_ENCODING);
            int idx = indexOfStringNode.execute((AbstractTruffleString)self, (AbstractTruffleString)old, 0, selfCpLen, PythonUtils.TS_ENCODING);
            if (idx < 0) {
                return self;
            }
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            int start = 0;
            int replacements = 0;
            do {
                TruffleString substr = substringNode.execute((AbstractTruffleString)self, start, idx - start, PythonUtils.TS_ENCODING, true);
                appendStringNode.execute(sb, (AbstractTruffleString)substr);
                appendStringNode.execute(sb, (AbstractTruffleString)with);
                start = idx + oldCpLen;
            } while (++replacements < maxCount && start < selfCpLen && (idx = indexOfStringNode.execute((AbstractTruffleString)self, (AbstractTruffleString)old, start, selfCpLen, PythonUtils.TS_ENCODING)) >= 0);
            TruffleString rest = substringNode.execute((AbstractTruffleString)self, start, selfCpLen - start, PythonUtils.TS_ENCODING, true);
            appendStringNode.execute(sb, (AbstractTruffleString)rest);
            return toStringNode.execute(sb);
        }

        public static StringReplaceNode getUncached() {
            return StringNodesFactory.StringReplaceNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class IsInternedStringNode
    extends Node {
        public abstract boolean execute(Node var1, PString var2);

        public static boolean executeUncached(PString string) {
            return StringNodesFactory.IsInternedStringNodeGen.getUncached().execute(null, string);
        }

        @Specialization
        static boolean doIt(Node inliningTarget, PString string, @Cached HiddenAttr.ReadNode readNode) {
            return (Boolean)readNode.execute(inliningTarget, string, HiddenAttr.INTERNED, Boolean.FALSE);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class InternStringNode
    extends Node {
        public abstract PString execute(Node var1, Object var2);

        public static PString executeUncached(Object string) {
            return StringNodesFactory.InternStringNodeGen.getUncached().execute(null, string);
        }

        @Specialization
        static PString doString(Node inliningTarget, TruffleString string, @Cached.Shared @Cached HiddenAttr.WriteNode writeNode, @Cached(inline=false) PythonObjectFactory factory) {
            PString interned = factory.createString(string);
            writeNode.execute(inliningTarget, interned, HiddenAttr.INTERNED, true);
            return interned;
        }

        @Specialization
        static PString doPString(Node inliningTarget, PString string, @Cached.Shared @Cached HiddenAttr.WriteNode writeNode) {
            if (PGuards.isBuiltinPString(string)) {
                writeNode.execute(inliningTarget, string, HiddenAttr.INTERNED, true);
                return string;
            }
            return null;
        }

        @Fallback
        static PString doOthers(Object string) {
            return null;
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class SpliceNode
    extends PNodeWithContext {
        public abstract void execute(TruffleStringBuilder var1, Object var2);

        @Specialization(guards={"isNone(none)"})
        static void doNone(TruffleStringBuilder sb, PNone none) {
        }

        @Specialization
        static void doInt(TruffleStringBuilder sb, int translated, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
            if (!Character.isValidCodePoint(translated)) {
                throw raise.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_UNICODE_CODE_POINT);
            }
            appendCodePointNode.execute(sb, translated, 1, true);
        }

        @Specialization
        static void doLong(TruffleStringBuilder sb, long translated, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
            try {
                SpliceNode.doInt(sb, PInt.intValueExact(translated), raise, appendCodePointNode);
            }
            catch (OverflowException e) {
                throw SpliceNode.raiseError(raise);
            }
        }

        @Specialization
        static void doPInt(TruffleStringBuilder sb, PInt translated, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached.Shared @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
            try {
                SpliceNode.doInt(sb, translated.intValueExact(), raise, appendCodePointNode);
            }
            catch (OverflowException e) {
                throw SpliceNode.raiseError(raise);
            }
        }

        @Specialization
        static void doString(TruffleStringBuilder sb, TruffleString translated, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
            appendStringNode.execute(sb, (AbstractTruffleString)translated);
        }

        @Specialization(guards={"!isInteger(translated)", "!isPInt(translated)", "!isNone(translated)"})
        static void doObject(TruffleStringBuilder sb, Object translated, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raise") @Cached PRaiseNode raise, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
            try {
                TruffleString translatedStr = castToStringNode.execute(inliningTarget, translated);
                SpliceNode.doString(sb, translatedStr, appendStringNode);
            }
            catch (CannotCastException e) {
                throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CHARACTER_MAPPING_MUST_RETURN_INT_NONE_OR_STR);
            }
        }

        private static PException raiseError(PRaiseNode raise) {
            return raise.raise(PythonErrorType.ValueError, ErrorMessages.CHARACTER_MAPPING_MUST_BE_IN_RANGE, PInt.toHexString(0x110000L));
        }
    }

    @ImportStatic(value={PGuards.class, PythonOptions.class})
    public static abstract class JoinInternalNode
    extends PNodeWithContext {
        public abstract TruffleString execute(VirtualFrame var1, TruffleString var2, Object var3);

        @Specialization
        static TruffleString doString(TruffleString self, TruffleString arg, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            if (arg.isEmpty()) {
                return StringLiterals.T_EMPTY_STRING;
            }
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)arg, PythonUtils.TS_ENCODING);
            assert (it.hasNext());
            appendCodePointNode.execute(sb, nextNode.execute(it), 1, true);
            while (it.hasNext()) {
                appendStringNode.execute(sb, (AbstractTruffleString)self);
                appendCodePointNode.execute(sb, nextNode.execute(it), 1, true);
            }
            return toStringNode.execute(sb);
        }

        @Specialization(guards={"isExactlyListOrTuple(inliningTarget, getClassNode, sequence)"}, limit="1")
        static TruffleString doPSequence(TruffleString self, PSequence sequence, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached InlinedConditionProfile isEmptyProfile, @Cached InlinedConditionProfile isSingleItemProfile, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached.Exclusive @Cached CastToTruffleStringNode castToStringNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raise, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
            int len = storage.length();
            if (isEmptyProfile.profile(inliningTarget, len == 0)) {
                return StringLiterals.T_EMPTY_STRING;
            }
            int i = 0;
            Object item = getItemNode.execute(storage, i);
            try {
                if (isSingleItemProfile.profile(inliningTarget, len == 1)) {
                    return castToStringNode.execute(inliningTarget, item);
                }
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(sb, (AbstractTruffleString)castToStringNode.execute(inliningTarget, item));
                for (i = 1; i < len; ++i) {
                    appendStringNode.execute(sb, (AbstractTruffleString)self);
                    item = getItemNode.execute(storage, i);
                    appendStringNode.execute(sb, (AbstractTruffleString)castToStringNode.execute(inliningTarget, item));
                }
                return toStringNode.execute(sb);
            }
            catch (OutOfMemoryError e) {
                throw raise.get(inliningTarget).raise(PythonErrorType.MemoryError);
            }
            catch (CannotCastException e) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_SEQ_ITEM, i, item);
            }
        }

        @Specialization
        static TruffleString doGeneric(VirtualFrame frame, TruffleString string, Object iterable, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raise, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile0, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile1, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile2, @Cached.Exclusive @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            Object iterator;
            try {
                iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile0);
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_JOIN_ITERABLE);
            }
            try {
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                try {
                    appendStringNode.execute(sb, (AbstractTruffleString)JoinInternalNode.checkItem(inliningTarget, nextNode.execute((Frame)frame, iterator), 0, castToStringNode, raise));
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile1);
                    return StringLiterals.T_EMPTY_STRING;
                }
                int i = 1;
                while (true) {
                    Object value;
                    try {
                        value = nextNode.execute((Frame)frame, iterator);
                    }
                    catch (PException e) {
                        e.expectStopIteration(inliningTarget, errorProfile2);
                        return toStringNode.execute(sb);
                    }
                    appendStringNode.execute(sb, (AbstractTruffleString)string);
                    appendStringNode.execute(sb, (AbstractTruffleString)JoinInternalNode.checkItem(inliningTarget, value, i++, castToStringNode, raise));
                }
            }
            catch (OutOfMemoryError e) {
                throw raise.get(inliningTarget).raise(PythonErrorType.MemoryError);
            }
        }

        private static TruffleString checkItem(Node inliningTarget, Object item, int pos, CastToTruffleStringNode castNode, PRaiseNode.Lazy raise) {
            try {
                return castNode.execute(inliningTarget, item);
            }
            catch (CannotCastException e) {
                throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INVALID_SEQ_ITEM, pos, item);
            }
        }

        static boolean isExactlyListOrTuple(Node inliningTarget, GetClassNode getClassNode, PSequence sequence) {
            Object clazz = getClassNode.execute(inliningTarget, sequence);
            return clazz == PythonBuiltinClassType.PList || clazz == PythonBuiltinClassType.PTuple;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CastToTruffleStringCheckedNode
    extends PNodeWithContext {
        public final TruffleString cast(Node inliningTarget, Object object, TruffleString errMsgFormat, Object ... errMsgArgs) {
            return this.execute(inliningTarget, object, errMsgFormat, errMsgArgs);
        }

        abstract TruffleString execute(Node var1, Object var2, TruffleString var3, Object[] var4);

        @Specialization
        static TruffleString doTruffleString(TruffleString self, TruffleString errMsgFormat, Object[] errMsgArgs) {
            return self;
        }

        @Specialization(guards={"!isTruffleString(self)"})
        static TruffleString doConvert(Node inliningTarget, Object self, TruffleString errMsgFormat, Object[] errMsgArgs, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return castToTruffleStringNode.execute(inliningTarget, self);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, errMsgFormat, errMsgArgs);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CastToJavaStringCheckedNode
    extends PNodeWithContext {
        public final String cast(Node inliningTarget, Object object, TruffleString errMsgFormat, Object ... errMsgArgs) {
            return this.executeInternal(inliningTarget, object, errMsgFormat, errMsgArgs);
        }

        protected abstract String executeInternal(Node var1, Object var2, TruffleString var3, Object[] var4);

        @Specialization
        static String doConvert(TruffleString self, TruffleString errMsgFormat, Object[] errMsgArgs, @Cached(inline=false) TruffleString.ToJavaStringNode toJavaStringNode) {
            return toJavaStringNode.execute((AbstractTruffleString)self);
        }

        @Specialization(guards={"!isTruffleString(self)"})
        static String doConvert(Node inliningTarget, Object self, TruffleString errMsgFormat, Object[] errMsgArgs, @Cached(inline=false) CastToJavaStringNode castToJavaStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return castToJavaStringNode.execute(self);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, errMsgFormat, errMsgArgs);
            }
        }
    }

    @GenerateUncached
    @ImportStatic(value={StringNodes.class})
    public static abstract class StringLenNode
    extends PNodeWithContext {
        public abstract int execute(Object var1);

        @Specialization
        static int doString(TruffleString str, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            return codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"x.isMaterialized()"})
        static int doMaterialized(PString x, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            return StringLenNode.doString(x.getMaterialized(), codePointLengthNode);
        }

        @Specialization(guards={"x.isNativeCharSequence()", "isKnownLength(elements)"})
        static int doNativeKnownLength(PString x, @Bind(value="x.getNativeCharSequence().getElements()") int elements) {
            return elements;
        }

        @Specialization(guards={"x.isNativeCharSequence()", "!isKnownLength(elements)"})
        static int doNativeUnknownLength(PString x, @Bind(value="x.getNativeCharSequence().getElements()") int elements, @Bind(value="this") Node inliningTarget, @Cached StringMaterializeNode materializeNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            return StringLenNode.doString(materializeNode.execute(inliningTarget, x), codePointLengthNode);
        }

        static boolean isKnownLength(int elements) {
            return elements != -1;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static int doNativeObject(PythonNativeObject x, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached CExtNodes.PCallCapiFunction callNativeUnicodeAsStringNode, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached PRaiseNode raiseNode) {
            if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, x), (Object)PythonBuiltinClassType.PString)) {
                Object result = callNativeUnicodeAsStringNode.call(NativeCAPISymbol.FUN_PY_UNICODE_GET_LENGTH, toSulongNode.execute(x));
                assert (result instanceof Number);
                return StringLenNode.intValue((Number)result);
            }
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static int other(Object x, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringCheckedNode cast, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            TruffleString tstring = cast.cast(inliningTarget, x, ErrorMessages.DESCRIPTOR_REQUIRES_S_OBJ_RECEIVED_P, "str", x);
            return StringLenNode.doString(tstring, codePointLengthNode);
        }

        @CompilerDirectives.TruffleBoundary
        private static int intValue(Number result) {
            return result.intValue();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={StringNodes.class})
    public static abstract class StringMaterializeNode
    extends Node {
        public static TruffleString executeUncached(PString s) {
            return StringNodesFactory.StringMaterializeNodeGen.getUncached().execute(null, s);
        }

        public abstract TruffleString execute(Node var1, PString var2);

        @Specialization(guards={"x.isNativeCharSequence()", "x.isNativeMaterialized()"})
        static TruffleString doMaterializedNative(PString x) {
            return x.getNativeCharSequence().getMaterialized();
        }

        @Specialization(guards={"x.isNativeCharSequence()", "!x.isMaterialized()"}, replaces={"doMaterializedNative"})
        @HostCompilerDirectives.InliningCutoff
        static TruffleString doNative(Node inliningTarget, PString x, @Cached CExtCommonNodes.ReadUnicodeArrayNode readArray, @Cached(inline=false) TruffleString.FromIntArrayUTF32Node fromArray) {
            NativeCharSequence sequence = x.getNativeCharSequence();
            assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32) : "needs switch_encoding otherwise";
            TruffleString materialized = fromArray.execute(readArray.execute(inliningTarget, sequence.getPtr(), sequence.getElements(), sequence.getElementSize()));
            x.setMaterialized(materialized);
            return materialized;
        }

        @Specialization(guards={"x.isMaterialized()"})
        static TruffleString doMaterialized(PString x) {
            return x.getMaterialized();
        }
    }
}

