/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.str;

import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.NativeCharSequence;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class PString
extends PSequence {
    private TruffleString materializedValue;
    private NativeCharSequence nativeCharSequence;
    private PBytes utf8Bytes;
    private PBytes wCharBytes;

    public PString(Object clazz, Shape instanceShape, NativeCharSequence value) {
        super(PythonUtils.builtinClassToType(clazz), instanceShape);
        this.nativeCharSequence = value;
    }

    public PString(Object clazz, Shape instanceShape, TruffleString value) {
        super(PythonUtils.builtinClassToType(clazz), instanceShape);
        assert (value != null);
        this.materializedValue = value;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getValueUncached() {
        return this.isMaterialized() ? this.getMaterialized() : StringNodes.StringMaterializeNode.executeUncached(this);
    }

    public boolean isNativeCharSequence() {
        return this.nativeCharSequence != null;
    }

    public boolean isNativeMaterialized() {
        assert (this.isNativeCharSequence());
        return this.nativeCharSequence.isMaterialized();
    }

    public boolean isMaterialized() {
        return this.materializedValue != null;
    }

    public TruffleString getMaterialized() {
        assert (this.isMaterialized());
        return this.materializedValue;
    }

    public void setMaterialized(TruffleString materialized) {
        assert (!this.isMaterialized());
        this.materializedValue = materialized;
    }

    public NativeCharSequence getNativeCharSequence() {
        assert (this.isNativeCharSequence());
        return this.nativeCharSequence;
    }

    public void setNativeCharSequence(NativeCharSequence nativeCharSequence) {
        this.nativeCharSequence = nativeCharSequence;
    }

    @Override
    public String toString() {
        return this.isMaterialized() ? this.materializedValue.toJavaStringUncached() : this.nativeCharSequence.toString();
    }

    public PBytes getUtf8Bytes() {
        return this.utf8Bytes;
    }

    public void setUtf8Bytes(PBytes bytes) {
        this.utf8Bytes = bytes;
    }

    public PBytes getWCharBytes() {
        return this.wCharBytes;
    }

    public void setWCharBytes(PBytes bytes) {
        this.wCharBytes = bytes;
    }

    @Override
    public SequenceStorage getSequenceStorage() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.isMaterialized() ? this.materializedValue.hashCode() : this.nativeCharSequence.hashCode();
    }

    @ExportMessage.Ignore
    public boolean equals(Object obj) {
        return obj != null && obj.equals(this.isMaterialized() ? this.materializedValue : this.nativeCharSequence);
    }

    @Override
    @ExportMessage
    public boolean isString() {
        return true;
    }

    @ExportMessage
    String asString(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="materialize") @Cached StringNodes.StringMaterializeNode stringMaterializeNode, @Cached.Shared(value="gil") @Cached GilNode gil, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        return toJavaStringNode.execute((AbstractTruffleString)this.asTruffleString(inliningTarget, stringMaterializeNode, gil));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    TruffleString asTruffleString(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="materialize") @Cached StringNodes.StringMaterializeNode stringMaterializeNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            TruffleString truffleString = stringMaterializeNode.execute(inliningTarget, this);
            return truffleString;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    Object readArrayElement(long index, @Bind(value="$node") Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Integer n = codePointAtIndexNode.execute((AbstractTruffleString)cast.execute(inliningTarget, this), (int)index, PythonUtils.TS_ENCODING);
            return n;
        }
        catch (CannotCastException e) {
            throw CompilerDirectives.shouldNotReachHere((String)"A PString should always have an underlying CharSequence");
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    long getArraySize(@Cached.Exclusive @Cached StringNodes.StringLenNode lenNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            long l = lenNode.execute(this);
            return l;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @Override
    public void setSequenceStorage(SequenceStorage store) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    @ExportMessage
    static boolean isArrayElementModifiable(PString self, long index) {
        return false;
    }

    @ExportMessage
    static boolean isArrayElementInsertable(PString self, long index) {
        return false;
    }

    @ExportMessage
    static boolean isArrayElementRemovable(PString self, long index) {
        return false;
    }
}

