/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.objects.ssl.SSLCipher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SSLCipherStringMapping {
    private static final Map<String, List<SSLCipher>> mapping = new HashMap<String, List<SSLCipher>>();

    public static List<SSLCipher> get(String cipherString) {
        return mapping.get(cipherString);
    }

    static {
        mapping.put("ADH", Arrays.asList(SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA));
        mapping.put("AECDH", Arrays.asList(SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA));
        mapping.put("AES", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA));
        mapping.put("AES128", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA));
        mapping.put("AES256", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA));
        mapping.put("AESCCM", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM));
        mapping.put("AESCCM8", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8));
        mapping.put("AESGCM", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256));
        mapping.put("ALL", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256));
        mapping.put("ARIA", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256));
        mapping.put("ARIA128", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256));
        mapping.put("ARIA256", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384));
        mapping.put("ARIAGCM", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256));
        mapping.put("CAMELLIA", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256));
        mapping.put("CAMELLIA128", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256));
        mapping.put("CAMELLIA256", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384));
        mapping.put("CHACHA20", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_WITH_CHACHA20_POLY1305_SHA256));
        mapping.put("COMPLEMENTOFALL", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_MD5, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("COMPLEMENTOFDEFAULT", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256));
        mapping.put("DH", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA));
        mapping.put("DHE", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA));
        mapping.put("DSS", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA));
        mapping.put("ECDH", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA));
        mapping.put("ECDHE", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA));
        mapping.put("ECDSA", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA));
        mapping.put("EDH", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA));
        mapping.put("EECDH", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA));
        mapping.put("FIPS", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA));
        mapping.put("HIGH", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256));
        mapping.put("IDEA", Arrays.asList(SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA));
        mapping.put("MD5", Arrays.asList(SSLCipher.TLS_RSA_WITH_NULL_MD5));
        mapping.put("MEDIUM", Arrays.asList(SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA));
        mapping.put("NULL", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_MD5, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("PSK", Arrays.asList(SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("RSA", Arrays.asList(SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_NULL_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_MD5));
        mapping.put("SEED", Arrays.asList(SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA));
        mapping.put("SHA", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("SHA1", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("SHA256", Arrays.asList(SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA256));
        mapping.put("SHA384", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA384));
        mapping.put("SRP", Arrays.asList(SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA));
        mapping.put("SSLv3", Arrays.asList(SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_MD5, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("TLSv1", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256));
        mapping.put("TLSv1.0", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256));
        mapping.put("TLSv1.2", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_NULL_SHA256));
        mapping.put("aDSS", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA));
        mapping.put("aECDSA", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA));
        mapping.put("aNULL", Arrays.asList(SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA));
        mapping.put("aPSK", Arrays.asList(SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("aRSA", Arrays.asList(SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_NULL_SHA256, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_MD5));
        mapping.put("aSRP", Arrays.asList(SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA));
        mapping.put("eNULL", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_MD5, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("kDHE", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA));
        mapping.put("kDHEPSK", Arrays.asList(SSLCipher.TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CCM, SSLCipher.TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_DHE_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CCM, SSLCipher.TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_DHE_PSK_WITH_NULL_SHA));
        mapping.put("kECDHE", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA));
        mapping.put("kECDHEPSK", Arrays.asList(SSLCipher.TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA384, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA256, SSLCipher.TLS_ECDHE_PSK_WITH_NULL_SHA));
        mapping.put("kEDH", Arrays.asList(SSLCipher.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_DH_anon_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CCM, SSLCipher.TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_DHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_SEED_CBC_SHA, SSLCipher.TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_SEED_CBC_SHA, SSLCipher.TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA));
        mapping.put("kEECDH", Arrays.asList(SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CCM, SSLCipher.TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_256_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDH_anon_WITH_AES_128_CBC_SHA, SSLCipher.TLS_ECDHE_ECDSA_WITH_NULL_SHA, SSLCipher.TLS_ECDHE_RSA_WITH_NULL_SHA, SSLCipher.TLS_ECDH_anon_WITH_NULL_SHA));
        mapping.put("kPSK", Arrays.asList(SSLCipher.TLS_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_PSK_WITH_AES_256_CCM_8, SSLCipher.TLS_PSK_WITH_AES_256_CCM, SSLCipher.TLS_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CCM_8, SSLCipher.TLS_PSK_WITH_AES_128_CCM, SSLCipher.TLS_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA384, SSLCipher.TLS_PSK_WITH_NULL_SHA256, SSLCipher.TLS_PSK_WITH_NULL_SHA));
        mapping.put("kRSA", Arrays.asList(SSLCipher.TLS_RSA_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_256_CCM_8, SSLCipher.TLS_RSA_WITH_AES_256_CCM, SSLCipher.TLS_RSA_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CCM_8, SSLCipher.TLS_RSA_WITH_AES_128_CCM, SSLCipher.TLS_RSA_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_WITH_NULL_SHA256, SSLCipher.TLS_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, SSLCipher.TLS_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_SEED_CBC_SHA, SSLCipher.TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, SSLCipher.TLS_RSA_WITH_IDEA_CBC_SHA, SSLCipher.TLS_RSA_WITH_NULL_SHA, SSLCipher.TLS_RSA_WITH_NULL_MD5));
        mapping.put("kRSAPSK", Arrays.asList(SSLCipher.TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, SSLCipher.TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_256_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_AES_128_CBC_SHA, SSLCipher.TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA384, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA256, SSLCipher.TLS_RSA_PSK_WITH_NULL_SHA));
        mapping.put("kSRP", Arrays.asList(SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_256_CBC_SHA, SSLCipher.TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA, SSLCipher.TLS_SRP_SHA_WITH_AES_128_CBC_SHA));
    }
}

