/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.property;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.property.PProperty;
import com.oracle.graal.python.builtins.objects.property.PropertyBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.property.PropertyBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PProperty})
public final class PropertyBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = PropertyBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PropertyBuiltinsFactory.getFactories();
    }

    @Builtin(name="__set_name__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class SetNameNode
    extends PythonTernaryBuiltinNode {
        SetNameNode() {
        }

        @Specialization
        Object setName(PProperty self, Object type, Object name) {
            self.setPropertyName(name);
            return PNone.NONE;
        }
    }

    @Builtin(name="__isabstractmethod__", parameterNames={"$self"}, isGetter=true)
    @GenerateNodeFactory
    static abstract class PropertyIsAbstractMethodNode
    extends PythonUnaryBuiltinNode {
        PropertyIsAbstractMethodNode() {
        }

        @Specialization
        static boolean doGeneric(VirtualFrame frame, PProperty self, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached PyObjectIsTrueNode isTrueNode) {
            if (PropertyIsAbstractMethodNode.isAbstract(frame, inliningTarget, lookup, isTrueNode, self.getFget())) {
                return true;
            }
            if (PropertyIsAbstractMethodNode.isAbstract(frame, inliningTarget, lookup, isTrueNode, self.getFset())) {
                return true;
            }
            return PropertyIsAbstractMethodNode.isAbstract(frame, inliningTarget, lookup, isTrueNode, self.getFdel());
        }

        private static boolean isAbstract(VirtualFrame frame, Node inliningTarget, PyObjectLookupAttr lookup, PyObjectIsTrueNode isTrueNode, Object func) {
            if (func == null) {
                return false;
            }
            Object result = lookup.execute((Frame)frame, inliningTarget, func, SpecialMethodNames.T___ISABSTRACTMETHOD__);
            if (result != PNone.NO_VALUE) {
                return isTrueNode.execute((Frame)frame, inliningTarget, result);
            }
            return false;
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_set, isComplex=true)
    @GenerateNodeFactory
    static abstract class DescrSet
    extends TpSlotDescrSet.DescrSetBuiltinNode {
        DescrSet() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        void doGenericSet(VirtualFrame frame, PProperty self, Object obj, Object value, @Cached CallBinaryMethodNode callNode, @Cached.Shared @Cached PropertyErrorNode propertyErrorNode) {
            Object func = self.getFset();
            if (func == null) {
                throw propertyErrorNode.execute(frame, self, obj, "setter");
            }
            callNode.executeObject((Frame)frame, func, obj, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        void doGenericDel(VirtualFrame frame, PProperty self, Object obj, Object value, @Cached CallUnaryMethodNode callNode, @Cached.Shared @Cached PropertyErrorNode propertyErrorNode) {
            Object func = self.getFdel();
            if (func == null) {
                throw propertyErrorNode.execute(frame, self, obj, "deleter");
            }
            callNode.executeObject((Frame)frame, func, obj);
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get, isComplex=true)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class PropertyGetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        PropertyGetNode() {
        }

        @Specialization
        static Object get(VirtualFrame frame, PProperty self, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile objIsPNoneProfile, @Cached CallUnaryMethodNode callNode, @Cached PropertyErrorNode propertyErrorNode) {
            if (objIsPNoneProfile.profile(inliningTarget, PGuards.isPNone(obj))) {
                return self;
            }
            Object fget = self.getFget();
            if (fget == null) {
                PropertyGetNode.raisePropertyError(frame, self, obj, propertyErrorNode);
            }
            return callNode.executeObject((Frame)frame, fget, obj);
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raisePropertyError(VirtualFrame frame, PProperty self, Object obj, PropertyErrorNode propertyErrorNode) {
            throw propertyErrorNode.execute(frame, self, obj, "getter");
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class PropertyErrorNode
    extends Node {
        PropertyErrorNode() {
        }

        abstract PException execute(VirtualFrame var1, PProperty var2, Object var3, String var4);

        @Specialization
        PException error(VirtualFrame frame, PProperty self, Object obj, String what, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetQualNameNode getQualNameNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached PRaiseNode raiseNode) {
            TruffleString qualName = getQualNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, obj));
            if (self.getPropertyName() != null) {
                TruffleString propertyName = reprNode.execute((Frame)frame, inliningTarget, self.getPropertyName());
                throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.PROPERTY_S_OF_S_OBJECT_HAS_NO_S, propertyName, qualName, what);
            }
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.PROPERTY_OF_S_OBJECT_HAS_NO_S, qualName, what);
        }
    }

    @Builtin(name="deleter", parameterNames={"$self", "deleter"}, doc="Descriptor to change the deleter on a property.")
    @GenerateNodeFactory
    static abstract class PropertyDeleterNode
    extends PropertyCopyingNode {
        PropertyDeleterNode() {
        }

        @Specialization
        static Object doGeneric(PProperty self, Object deleter) {
            return PropertyDeleterNode.copy(self, PNone.NO_VALUE, PNone.NO_VALUE, deleter);
        }
    }

    @Builtin(name="setter", parameterNames={"$self", "setter"}, doc="Descriptor to change the setter on a property.")
    @GenerateNodeFactory
    static abstract class PropertySetterNode
    extends PropertyCopyingNode {
        PropertySetterNode() {
        }

        @Specialization
        static Object doGeneric(PProperty self, Object setter) {
            return PropertySetterNode.copy(self, PNone.NO_VALUE, setter, PNone.NO_VALUE);
        }
    }

    @Builtin(name="getter", parameterNames={"$self", "getter"}, doc="Descriptor to change the getter on a property.")
    @GenerateNodeFactory
    static abstract class PropertyGetterNode
    extends PropertyCopyingNode {
        PropertyGetterNode() {
        }

        @Specialization
        static Object doGeneric(PProperty self, Object getter) {
            return PropertyGetterNode.copy(self, getter, PNone.NO_VALUE, PNone.NO_VALUE);
        }
    }

    static abstract class PropertyCopyingNode
    extends PythonBinaryBuiltinNode {
        PropertyCopyingNode() {
        }

        @CompilerDirectives.TruffleBoundary
        static Object copy(PProperty pold, Object getArg, Object setArg, Object delArg) {
            Object doc;
            Object type = GetClassNode.GetPythonObjectClassNode.executeUncached(pold);
            Object get = PGuards.isPNone(getArg) ? (pold.getFget() != null ? pold.getFget() : PNone.NONE) : getArg;
            Object set = PGuards.isPNone(setArg) ? (pold.getFset() != null ? pold.getFset() : PNone.NONE) : setArg;
            Object del = PGuards.isPNone(delArg) ? (pold.getFdel() != null ? pold.getFdel() : PNone.NONE) : delArg;
            if (pold.getGetterDoc() && get != PNone.NONE) {
                doc = PNone.NONE;
            } else {
                Object object = doc = pold.getDoc() != null ? pold.getDoc() : PNone.NONE;
            }
            if (BuiltinClassProfiles.IsBuiltinClassProfile.profileClassSlowPath(type, PythonBuiltinClassType.PProperty)) {
                PProperty copy = PythonObjectFactory.getUncached().createProperty();
                PropertyInitNode.doGeneric(copy, get, set, del, doc);
                return copy;
            }
            PProperty newProp = (PProperty)CallNode.executeUncached(type, get, set, del, doc);
            newProp.setPropertyName(pold.getPropertyName());
            return newProp;
        }
    }

    @Builtin(name="__doc__", minNumOfPositionalArgs=1, parameterNames={"$self", "value"}, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class PropertyDocNode
    extends PythonBinaryBuiltinNode {
        PropertyDocNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object doGet(PProperty self, PNone value) {
            Object doc = self.getDoc();
            return doc != null ? doc : PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object doSet(PProperty self, Object value) {
            self.setDoc(value);
            return PNone.NONE;
        }
    }

    @Builtin(name="fdel", minNumOfPositionalArgs=1, parameterNames={"$self", "value"}, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class PropertyFDelNode
    extends PropertyFuncNode {
        PropertyFDelNode() {
        }

        @Specialization(guards={"isNoValue(value)"}, insertBefore="doSet")
        static Object doGet(PProperty self, PNone value) {
            Object fdel = self.getFdel();
            return fdel != null ? fdel : PNone.NONE;
        }
    }

    @Builtin(name="fset", minNumOfPositionalArgs=1, parameterNames={"$self", "value"}, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class PropertyFSetNode
    extends PropertyFuncNode {
        PropertyFSetNode() {
        }

        @Specialization(guards={"isNoValue(value)"}, insertBefore="doSet")
        static Object doGet(PProperty self, PNone value) {
            Object fset = self.getFset();
            return fset != null ? fset : PNone.NONE;
        }
    }

    @Builtin(name="fget", minNumOfPositionalArgs=1, parameterNames={"$self", "value"}, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class PropertyFGetNode
    extends PropertyFuncNode {
        PropertyFGetNode() {
        }

        @Specialization(guards={"isNoValue(value)"}, insertBefore="doSet")
        static Object doGet(PProperty self, PNone value) {
            Object fget = self.getFget();
            return fget != null ? fget : PNone.NONE;
        }
    }

    static abstract class PropertyFuncNode
    extends PythonBinaryBuiltinNode {
        PropertyFuncNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object doSet(PProperty self, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.READONLY_ATTRIBUTE);
        }
    }

    @Builtin(name="__init__", parameterNames={"$self", "fget", "fset", "fdel", "doc"})
    @GenerateNodeFactory
    static abstract class PropertyInitNode
    extends PythonBuiltinNode {
        PropertyInitNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(PProperty self, Object fget, Object fset, Object fdel, Object doc) {
            Object get_doc;
            if (!PGuards.isPNone(fget)) {
                self.setFget(fget);
            }
            if (!PGuards.isPNone(fset)) {
                self.setFset(fset);
            }
            if (!PGuards.isPNone(fdel)) {
                self.setFdel(fdel);
            }
            if (doc != PNone.NO_VALUE) {
                self.setDoc(doc);
            }
            if ((doc == PNone.NO_VALUE || doc == PNone.NONE) && fget != PNone.NO_VALUE && (get_doc = PyObjectLookupAttr.executeUncached(fget, SpecialAttributeNames.T___DOC__)) != PNone.NO_VALUE) {
                if (BuiltinClassProfiles.IsBuiltinClassExactProfile.profileClassSlowPath(GetClassNode.GetPythonObjectClassNode.executeUncached(self), PythonBuiltinClassType.PProperty)) {
                    self.setDoc(get_doc);
                } else {
                    WriteAttributeToObjectNode.getUncached().execute(self, SpecialAttributeNames.T___DOC__, get_doc);
                }
                self.setGetterDoc(true);
            }
            return PNone.NONE;
        }
    }
}

