/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.itertools.CombinationsBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PAbstractCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinationsWithReplacement;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCombinations, PythonBuiltinClassType.PCombinationsWithReplacement})
public final class CombinationsBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CombinationsBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PAbstractCombinations self, Object stateObj, @Bind(value="this") Node inliningTarget, @Cached CastToJavaIntExactNode cast, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached PRaiseNode.Lazy raiseNode) {
            PTuple state;
            int n = self.getPool().length;
            if (stateObj instanceof PTuple && (state = (PTuple)stateObj).getSequenceStorage().length() == self.getR()) {
                SequenceStorage storage = state.getSequenceStorage();
                try {
                    for (int i = 0; i < self.getR(); ++i) {
                        int max;
                        int index = cast.execute(inliningTarget, getItemNode.execute(inliningTarget, storage, i));
                        if (index > (max = i + n - self.getR())) {
                            index = max;
                        }
                        if (index < 0) {
                            index = 0;
                        }
                        self.getIndices()[i] = index;
                    }
                }
                catch (CannotCastException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
                }
                Object[] result = new Object[self.getR()];
                for (int i = 0; i < self.getR(); ++i) {
                    result[i] = self.getPool()[self.getIndices()[i]];
                }
                self.setLastResult(result);
                return PNone.NONE;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PAbstractCombinations self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasNoLastResultProfile, @Cached InlinedConditionProfile stoppedProfile, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            Object type = getClassNode.execute(inliningTarget, self);
            if (hasNoLastResultProfile.profile(inliningTarget, self.getLastResult() == null)) {
                PTuple args = factory.createTuple(new Object[]{factory.createTuple(self.getPool()), self.getR()});
                return factory.createTuple(new Object[]{type, args});
            }
            if (stoppedProfile.profile(inliningTarget, self.isStopped())) {
                PTuple args = factory.createTuple(new Object[]{factory.createEmptyTuple(), self.getR()});
                return factory.createTuple(new Object[]{type, args});
            }
            PTuple indices = factory.createTuple(PythonUtils.arrayCopyOf(self.getIndices(), self.getR()));
            PTuple args = factory.createTuple(new Object[]{factory.createTuple(self.getPool()), self.getR()});
            return factory.createTuple(new Object[]{type, args, indices});
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isStopped()"})
        static Object nextStopped(PAbstractCombinations self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseStopIteration();
        }

        @Specialization(guards={"!self.isStopped()", "isLastResultNull(self)"})
        static Object nextNoResult(PAbstractCombinations self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared PythonObjectFactory factory, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopConditionProfile) {
            Object[] result = new Object[self.getR()];
            loopConditionProfile.profileCounted(inliningTarget, (long)self.getR());
            int i = 0;
            while (loopConditionProfile.inject(inliningTarget, i < self.getR())) {
                int idx = self.getIndices()[i];
                result[i] = self.getPool()[idx];
                ++i;
            }
            self.setLastResult(result);
            return factory.createTuple(result);
        }

        @Specialization(guards={"!self.isStopped()", "!isLastResultNull(self)"})
        static Object next(PCombinations self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached InlinedLoopConditionProfile indexLoopProfile, @Cached.Shared @Cached InlinedLoopConditionProfile resultLoopProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return NextNode.nextInternal(inliningTarget, self, factory, indexLoopProfile, resultLoopProfile, raiseNode);
        }

        @Specialization(guards={"!self.isStopped()", "!isLastResultNull(self)"})
        static Object next(PCombinationsWithReplacement self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached InlinedLoopConditionProfile indexLoopProfile, @Cached.Shared @Cached InlinedLoopConditionProfile resultLoopProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return NextNode.nextInternal(inliningTarget, self, factory, indexLoopProfile, resultLoopProfile, raiseNode);
        }

        private static Object nextInternal(Node inliningTarget, PAbstractCombinations self, PythonObjectFactory factory, InlinedLoopConditionProfile indexLoopProfile, InlinedLoopConditionProfile resultLoopProfile, PRaiseNode.Lazy raiseNode) throws PException {
            int i;
            CompilerAsserts.partialEvaluationConstant(self.getClass());
            Object[] result = PythonUtils.arrayCopyOf(self.getLastResult(), self.getLastResult().length);
            int poolLen = self.getPool().length;
            for (i = self.getR() - 1; i >= 0 && self.getIndices()[i] == self.getMaximum(poolLen, i); --i) {
            }
            if (i < 0) {
                self.setStopped(true);
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            int[] nArray = self.getIndices();
            int n = i;
            nArray[n] = nArray[n] + 1;
            indexLoopProfile.profileCounted(inliningTarget, (long)(self.getR() - i + 1));
            int j = i + 1;
            while (indexLoopProfile.inject(inliningTarget, j < self.getR())) {
                self.getIndices()[j] = self.maxIndex(j);
                ++j;
            }
            resultLoopProfile.profileCounted(inliningTarget, (long)(self.getR() - i));
            j = i;
            while (resultLoopProfile.inject(inliningTarget, j < self.getR())) {
                Object elem;
                int index = self.getIndices()[j];
                result[j] = elem = self.getPool()[index];
                ++j;
            }
            self.setLastResult(result);
            return factory.createTuple(result);
        }

        protected boolean isLastResultNull(PAbstractCombinations self) {
            return self.getLastResult() == null;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PAbstractCombinations self) {
            return self;
        }
    }
}

