/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.deque;

import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.util.Iterator;

public final class PDequeIter
extends PBuiltinIterator {
    final PDeque deque;
    final int startState;
    private final Iterator<Object> iterator;
    private int remaining;

    public PDequeIter(Object cls, Shape instanceShape, PDeque deque, boolean reverse) {
        super(cls, instanceShape);
        this.deque = deque;
        this.iterator = reverse ? deque.reverseIterator() : deque.iterator();
        this.remaining = deque.getSize();
        this.startState = deque.getState();
    }

    @CompilerDirectives.TruffleBoundary
    boolean hasNext() {
        return this.iterator.hasNext();
    }

    @CompilerDirectives.TruffleBoundary
    Object next() {
        Object next = this.iterator.next();
        --this.remaining;
        return next;
    }

    int lengthHint() {
        return this.remaining;
    }

    void reset() {
        this.remaining = 0;
    }
}

