/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

public final class ForeignHashingStorage
extends HashingStorage {
    public final Object foreignDict;

    public ForeignHashingStorage(Object foreignDict) {
        assert (IsForeignObjectNode.executeUncached(foreignDict));
        assert (InteropLibrary.getUncached().hasHashEntries(foreignDict));
        this.foreignDict = foreignDict;
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ClearNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, ForeignHashingStorage var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static void clear(Node inliningTarget, ForeignHashingStorage storage, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary iteratorInterop, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                int i;
                Object[] keys = new Object[32];
                do {
                    i = 0;
                    Object iterator = interop.getHashKeysIterator(storage.foreignDict);
                    while (i < keys.length && iteratorInterop.hasIteratorNextElement(iterator)) {
                        Object key = iteratorInterop.getIteratorNextElement(iterator);
                        keys[i++] = key;
                    }
                    for (int k = 0; k < i; ++k) {
                        ClearNode.remove(inliningTarget, storage.foreignDict, keys[k], interop, raiseNode);
                    }
                } while (i == keys.length);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            catch (StopIterationException stopIterationException) {
            }
            finally {
                gil.acquire();
            }
        }

        private static void remove(Node inliningTarget, Object dict, Object key, InteropLibrary interop, PRaiseNode.Lazy raiseNode) {
            try {
                interop.removeHashEntry(dict, key);
            }
            catch (UnknownKeyException unknownKeyException) {
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_REMOVABLE, key, dict);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PopNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, ForeignHashingStorage var2, Object var3);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static Object pop(Node inliningTarget, ForeignHashingStorage storage, Object key, @Cached GetNode getNode, @Cached RemoveNode removeNode2, @Cached(inline=false) PForeignToPTypeNode toPythonNode) {
            Object value = getNode.execute(inliningTarget, storage, key);
            if (!removeNode2.execute(inliningTarget, storage, key)) {
                return null;
            }
            return toPythonNode.executeConvert(value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class RemoveNode
    extends PNodeWithContext {
        public abstract boolean execute(Node var1, ForeignHashingStorage var2, Object var3);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static boolean remove(Node inliningTarget, ForeignHashingStorage storage, Object key, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            Object dict = storage.foreignDict;
            gil.release(true);
            try {
                interop.removeHashEntry(dict, key);
            }
            catch (UnknownKeyException e) {
                boolean bl = false;
                return bl;
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_REMOVABLE, key, dict);
            }
            finally {
                gil.acquire();
            }
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PutNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, ForeignHashingStorage var2, Object var3, Object var4);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static void put(Node inliningTarget, ForeignHashingStorage storage, Object key, Object value, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            Object dict = storage.foreignDict;
            gil.release(true);
            try {
                interop.writeHashEntry(dict, key, value);
            }
            catch (UnknownKeyException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, new Object[]{key});
            }
            catch (UnsupportedMessageException e) {
                if (interop.isHashEntryExisting(dict, key)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_WRITABLE, key, dict);
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_INSERTABLE, key, dict);
            }
            catch (UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.TYPE_P_NOT_SUPPORTED_BY_FOREIGN_OBJ, value);
            }
            finally {
                gil.acquire();
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, ForeignHashingStorage var2, Object var3);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static Object get(Node inliningTarget, ForeignHashingStorage storage, Object key, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached(inline=false) PForeignToPTypeNode toPythonNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object value;
            Object dict = storage.foreignDict;
            gil.release(true);
            try {
                value = interop.readHashValue(dict, key);
            }
            catch (UnknownKeyException e) {
                Object var10_11 = null;
                return var10_11;
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_READABLE, key, dict);
            }
            finally {
                gil.acquire();
            }
            return toPythonNode.executeConvert(value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class LengthNode
    extends PNodeWithContext {
        public abstract int execute(Node var1, ForeignHashingStorage var2);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static int length(Node inliningTarget, ForeignHashingStorage storage, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached InlinedBranchProfile errorProfile) {
            long size;
            gil.release(true);
            try {
                size = interop.getHashSize(storage.foreignDict);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
            return PInt.long2int(inliningTarget, size, errorProfile);
        }
    }
}

