/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class GetReplacementNode
extends Node {
    public abstract Object execute(Node var1, PythonNativeWrapper var2);

    @Specialization(guards={"isReplacingWrapper(wrapper)"})
    static Object doReplacingWrapper(PythonNativeWrapper wrapper, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
        return wrapper.getReplacement(lib);
    }

    @Specialization(guards={"!isReplacingWrapper(wrapper)"})
    static Object doWrapper(Node inliningTarget, PythonNativeWrapper wrapper) {
        if (wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
            PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
            if (!PythonContext.get(inliningTarget).isNativeAccessAllowed()) {
                return objectNativeWrapper;
            }
        }
        return null;
    }

    @Specialization(replaces={"doReplacingWrapper", "doWrapper"})
    static Object doGeneric(Node inliningTarget, PythonNativeWrapper wrapper, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
        if (wrapper.isReplacingWrapper()) {
            return wrapper.getReplacement(lib);
        }
        if (wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
            PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
            if (!PythonContext.get(inliningTarget).isNativeAccessAllowed()) {
                return objectNativeWrapper;
            }
        }
        return null;
    }

    static boolean isReplacingWrapper(PythonNativeWrapper wrapper) {
        return wrapper.isReplacingWrapper();
    }
}

