/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallTargetInvokeNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;

@ExportLibrary(value=InteropLibrary.class)
public abstract class PyCFunctionWrapper
implements TruffleObject {
    protected final RootCallTarget callTarget;
    protected final Signature signature;
    protected final TruffleString callTargetName;
    protected final BuiltinMethodDescriptor builtinMethodDescriptor;
    protected final CApiTiming timing;
    private long pointer;

    protected PyCFunctionWrapper(RootCallTarget callTarget, Signature signature) {
        assert (callTarget != null);
        assert (signature != null);
        this.callTarget = callTarget;
        this.signature = signature;
        String ctName = callTarget.getRootNode().getName();
        this.callTargetName = PythonUtils.toTruffleStringUncached(ctName);
        this.builtinMethodDescriptor = null;
        this.timing = CApiTiming.create(false, ctName);
    }

    protected PyCFunctionWrapper(BuiltinMethodDescriptor builtinMethodDescriptor) {
        assert (builtinMethodDescriptor != null);
        this.callTarget = null;
        this.signature = null;
        this.callTargetName = null;
        this.builtinMethodDescriptor = builtinMethodDescriptor;
        this.timing = CApiTiming.create(false, builtinMethodDescriptor.getName());
    }

    public final RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public final Object getDelegate() {
        if (this.builtinMethodDescriptor != null) {
            return this.builtinMethodDescriptor;
        }
        assert (this.callTarget != null);
        return this.callTarget;
    }

    abstract String getSignature();

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    protected Object execute(Object[] arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        throw CompilerDirectives.shouldNotReachHere((String)"abstract class");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected void toNative(@CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
        if (this.pointer == 0L) {
            CApiContext cApiContext = PythonContext.get(null).getCApiContext();
            this.pointer = cApiContext.registerClosure(this.getSignature(), this, this.getDelegate(), signatureLibrary);
        }
    }

    @ExportMessage
    protected boolean isPointer() {
        return this.pointer != 0L;
    }

    @ExportMessage
    protected long asPointer() {
        return this.pointer;
    }

    protected abstract String getFlagsRepr();

    @CompilerDirectives.TruffleBoundary
    private static String toString(Object name, String flagsRepr, long pointer) {
        String ptr = pointer != 0L ? " at 0x" + Long.toHexString(pointer) : "";
        return String.format("PyCFunction(%s, %s)%s", name, flagsRepr, ptr);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return PyCFunctionWrapper.toString(this.builtinMethodDescriptor != null ? this.builtinMethodDescriptor.getName() : this.callTargetName, this.getFlagsRepr(), this.pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static PyCFunctionWrapper createFromBuiltinFunction(CApiContext cApiContext, PBuiltinFunction builtinFunction) {
        int flags = builtinFunction.getFlags();
        BuiltinMethodDescriptor builtinMethodDescriptor = BuiltinMethodDescriptor.get(builtinFunction);
        if (builtinMethodDescriptor != null) {
            if (CExtContext.isMethNoArgs(flags) && builtinMethodDescriptor instanceof BuiltinMethodDescriptor.UnaryBuiltinDescriptor || CExtContext.isMethO(flags) && builtinMethodDescriptor instanceof BuiltinMethodDescriptor.BinaryBuiltinDescriptor) {
                cApiContext.getContext().getLanguage().registerBuiltinDescriptorCallTarget(builtinMethodDescriptor, builtinFunction.getCallTarget());
            }
            if (CExtContext.isMethNoArgs(flags) && builtinMethodDescriptor instanceof BuiltinMethodDescriptor.UnaryBuiltinDescriptor) {
                return cApiContext.getOrCreatePyCFunctionWrapper(builtinMethodDescriptor, PyCFunctionUnaryWrapper::new);
            }
            if (CExtContext.isMethO(flags) && builtinMethodDescriptor instanceof BuiltinMethodDescriptor.BinaryBuiltinDescriptor) {
                return cApiContext.getOrCreatePyCFunctionWrapper(builtinMethodDescriptor, PyCFunctionBinaryWrapper::new);
            }
        }
        RootCallTarget ct = builtinFunction.getCallTarget();
        Signature signature = builtinFunction.getSignature();
        if (CExtContext.isMethNoArgs(flags)) {
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionUnaryWrapper((RootCallTarget)k, signature));
        }
        if (CExtContext.isMethO(flags)) {
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionBinaryWrapper((RootCallTarget)k, signature));
        }
        if (CExtContext.isMethVarargs(flags)) {
            int numDefaults = builtinFunction.getDefaults().length;
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionVarargsWrapper((RootCallTarget)k, signature, numDefaults));
        }
        if (CExtContext.isMethVarargsWithKeywords(flags)) {
            int numDefaults = builtinFunction.getDefaults().length;
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionKeywordsWrapper((RootCallTarget)k, signature, numDefaults));
        }
        throw CompilerDirectives.shouldNotReachHere((String)("other signature " + Integer.toHexString(flags)));
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionKeywordsWrapper
    extends PyCFunctionWrapper {
        private final int numDefaults;

        PyCFunctionKeywordsWrapper(RootCallTarget callTarget, Signature signature, int numDefaults) {
            super(callTarget, signature);
            assert (numDefaults >= 0);
            this.numDefaults = numDefaults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached CreateArgumentsNode.CreateAndCheckArgumentsNode createArgsNode, @Cached CallTargetDispatchNode invokeNode2, @Cached ExpandKeywordStarargsNode expandKwargsNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 3) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)3, (int)arguments.length);
                }
                try {
                    Object receiver = toJavaNode.execute(arguments[0]);
                    Object starArgs = toJavaNode.execute(arguments[1]);
                    Object kwArgs = toJavaNode.execute(arguments[2]);
                    assert (this.builtinMethodDescriptor == null);
                    assert (this.callTarget != null);
                    assert (this.callTargetName != null);
                    Object[] starArgsArray = posStarargsNode.executeWith(null, starArgs);
                    PKeyword[] kwArgsArray = expandKwargsNode.execute(inliningTarget, kwArgs);
                    Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, starArgsArray, kwArgsArray, this.signature, receiver, null, PBuiltinFunction.generateDefaults(this.numDefaults), PKeyword.EMPTY_KEYWORDS, false);
                    Object result = invokeNode2.execute(inliningTarget, (CallTarget)this.callTarget, pArgs);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_KEYWORDS";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionVarargsWrapper
    extends PyCFunctionWrapper {
        private final int numDefaults;

        PyCFunctionVarargsWrapper(RootCallTarget callTarget, Signature signature, int numDefaults) {
            super(callTarget, signature);
            assert (numDefaults >= 0);
            this.numDefaults = numDefaults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached CreateArgumentsNode.CreateAndCheckArgumentsNode createArgsNode, @Cached CallTargetDispatchNode invokeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                try {
                    Object receiver = toJavaNode.execute(arguments[0]);
                    Object starArgs = toJavaNode.execute(arguments[1]);
                    assert (this.builtinMethodDescriptor == null);
                    assert (this.callTarget != null);
                    Object[] starArgsArray = posStarargsNode.executeWith(null, starArgs);
                    Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, starArgsArray, PKeyword.EMPTY_KEYWORDS, this.signature, receiver, null, PBuiltinFunction.generateDefaults(this.numDefaults), PKeyword.EMPTY_KEYWORDS, false);
                    Object result = invokeNode2.execute(inliningTarget, (CallTarget)this.callTarget, pArgs);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_VARARGS";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionBinaryWrapper
    extends PyCFunctionWrapper {
        PyCFunctionBinaryWrapper(RootCallTarget callTarget, Signature signature) {
            super(callTarget, signature);
        }

        private PyCFunctionBinaryWrapper(BuiltinMethodDescriptor builtinMethodDescriptor) {
            super(builtinMethodDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CallBinaryMethodNode callBinaryMethodNode, @Cached CallTargetDispatchNode invokeNode2, @Cached CreateArgumentsNode.CreateAndCheckArgumentsNode createArgsNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                try {
                    Object result;
                    Object jArg0 = toJavaNode.execute(arguments[0]);
                    Object jArg1 = toJavaNode.execute(arguments[1]);
                    if (this.builtinMethodDescriptor != null) {
                        assert (this.callTarget == null);
                        assert (this.builtinMethodDescriptor instanceof BuiltinMethodDescriptor.BinaryBuiltinDescriptor);
                        result = callBinaryMethodNode.executeObject(this.builtinMethodDescriptor, jArg0, jArg1);
                    } else {
                        assert (this.callTarget != null);
                        assert (this.callTargetName != null);
                        Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, new Object[]{jArg1}, PKeyword.EMPTY_KEYWORDS, this.signature, jArg0, null, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS, false);
                        result = invokeNode2.execute(inliningTarget, (CallTarget)this.callTarget, pArgs);
                    }
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_O";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionUnaryWrapper
    extends PyCFunctionWrapper {
        PyCFunctionUnaryWrapper(RootCallTarget callTarget, Signature signature) {
            super(callTarget, signature);
        }

        private PyCFunctionUnaryWrapper(BuiltinMethodDescriptor builtinMethodDescriptor) {
            super(builtinMethodDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CallUnaryMethodNode callUnaryNode, @Cached CreateArgumentsNode.CreateAndCheckArgumentsNode createArgsNode, @Cached CallTargetDispatchNode invokeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length > 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)1, (int)2, (int)arguments.length);
                }
                try {
                    Object result;
                    Object jArg0 = toJavaNode.execute(arguments[0]);
                    if (this.builtinMethodDescriptor != null) {
                        assert (this.callTarget == null);
                        result = callUnaryNode.executeObject(null, this.builtinMethodDescriptor, jArg0);
                    } else {
                        assert (this.callTarget != null);
                        assert (this.callTargetName != null);
                        Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS, this.signature, jArg0, null, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS, false);
                        result = invokeNode2.execute(inliningTarget, (CallTarget)this.callTarget, pArgs);
                    }
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_NOARGS";
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CallTargetDispatchNode
    extends Node {
        CallTargetDispatchNode() {
        }

        abstract Object execute(Node var1, CallTarget var2, Object[] var3);

        @Specialization(guards={"ct == cachedCt"}, limit="1")
        static Object doCallTargetDirect(CallTarget ct, Object[] args, @Cached(value="ct", weak=true) CallTarget cachedCt, @Cached(value="create(ct, true, false)") CallTargetInvokeNode callNode) {
            assert (PArguments.isPythonFrame(args));
            return callNode.execute(null, null, null, null, args);
        }

        @Specialization(replaces={"doCallTargetDirect"})
        static Object doCallTargetIndirect(CallTarget ct, Object[] args, @Cached(inline=false) GenericInvokeNode callNode) {
            assert (PArguments.isPythonFrame(args));
            return callNode.execute(ct, args);
        }
    }
}

