/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

public class PSemLock
extends PythonBuiltinObject {
    public static final int RECURSIVE_MUTEX = 0;
    public static final int SEMAPHORE = 1;
    private final long handle;
    private long lastThreadId;
    private int count;
    private final int maxValue;
    private final int kind;
    private final TruffleString name;

    public PSemLock(Object cls, Shape instanceShape, long handle, int kind, int maxValue, TruffleString name) {
        super(cls, instanceShape);
        this.handle = handle;
        this.maxValue = maxValue;
        this.kind = kind;
        this.name = name;
    }

    public long getHandle() {
        return this.handle;
    }

    public int getKind() {
        return this.kind;
    }

    public TruffleString getName() {
        return this.name;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void increaseCount() {
        ++this.count;
    }

    public void decreaseCount() {
        --this.count;
    }

    public void setLastThreadId(long lastThreadId) {
        this.lastThreadId = lastThreadId;
    }

    public boolean isMine() {
        return this.count > 0 && this.lastThreadId == PThread.getThreadId(Thread.currentThread());
    }
}

