/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.csv;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVWriter;
import com.oracle.graal.python.builtins.modules.csv.CSVWriterBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyNumberCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.CSVWriter})
public final class CSVWriterBuiltins
extends PythonBuiltins {
    private static final String WRITEROW_DOC = "writerow(iterable)\n\nConstruct and write a CSV record from an iterable of fields.  Non-string\nelements will be converted to string.";
    private static final String WRITEROWS_DOC = "writerows(iterable of iterables)\n\nConstruct and write a series of iterables to a csv file.  Non-string\nelements will be converted to string.";

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CSVWriterBuiltinsFactory.getFactories();
    }

    @Builtin(name="dialect", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetDialectNode
    extends PythonUnaryBuiltinNode {
        GetDialectNode() {
        }

        @Specialization
        static CSVDialect doIt(CSVWriter self) {
            return self.dialect;
        }
    }

    @Builtin(name="writerows", parameterNames={"$self", "seqseq"}, minNumOfPositionalArgs=2, doc="writerows(iterable of iterables)\n\nConstruct and write a series of iterables to a csv file.  Non-string\nelements will be converted to string.")
    @GenerateNodeFactory
    public static abstract class WriteRowsNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object doIt(VirtualFrame frame, CSVWriter self, Object seq, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode getNext, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached WriteRowNode writeRow) {
            Object iter = getIter.execute((Frame)frame, inliningTarget, seq);
            try {
                while (true) {
                    Object row = getNext.execute((Frame)frame, iter);
                    writeRow.execute(frame, self, row);
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, isBuiltinClassProfile);
                return PNone.NONE;
            }
        }
    }

    @Builtin(name="writerow", parameterNames={"$self", "seq"}, minNumOfPositionalArgs=2, doc="writerow(iterable)\n\nConstruct and write a CSV record from an iterable of fields.  Non-string\nelements will be converted to string.")
    @GenerateNodeFactory
    public static abstract class WriteRowNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, CSVWriter self, Object seq, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetClassNode getClass, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached CallUnaryMethodNode callNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PyObjectStrAsTruffleStringNode objectStrAsTruffleStringNode, @Cached PyNumberCheckNode pyNumberCheckNode, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached PRaiseNode.Lazy raiseNode) {
            Object iter;
            try {
                iter = getIter.execute((Frame)frame, inliningTarget, seq);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.EXPECTED_ITERABLE_NOT_S, getClass.execute(inliningTarget, seq));
            }
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            CSVDialect dialect = self.dialect;
            boolean first = true;
            try {
                while (true) {
                    Object field = getNextNode.execute((Frame)frame, iter);
                    if (!first) {
                        appendStringNode.execute(sb, (AbstractTruffleString)dialect.delimiter);
                    } else {
                        first = false;
                    }
                    WriteRowNode.joinField(inliningTarget, sb, dialect, field, createCodePointIteratorNode, nextNode, byteIndexOfCodePointNode, appendCodePointNode, appendStringNode, objectStrAsTruffleStringNode, pyNumberCheckNode, raiseNode);
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, isBuiltinClassProfile);
                if (!first && sb.isEmpty()) {
                    if (dialect.quoting == QuoteStyle.QUOTE_NONE) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.EMPTY_FIELD_RECORD_MUST_BE_QUOTED);
                    }
                    WriteRowNode.joinAppend(inliningTarget, sb, dialect, null, true, createCodePointIteratorNode, nextNode, byteIndexOfCodePointNode, appendCodePointNode, appendStringNode, raiseNode);
                }
                appendStringNode.execute(sb, (AbstractTruffleString)dialect.lineTerminator);
                return callNode.executeObject((Frame)frame, self.write, toStringNode.execute(sb));
            }
        }

        private static void joinField(Node inliningTarget, TruffleStringBuilder sb, CSVDialect dialect, Object field, TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, TruffleStringIterator.NextNode nextNode, TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.AppendStringNode appendStringNode, PyObjectStrAsTruffleStringNode objectStrAsTruffleStringNode, PyNumberCheckNode pyNumberCheckNode, PRaiseNode.Lazy raiseNode) {
            boolean quoted = switch (dialect.quoting) {
                case QuoteStyle.QUOTE_NONNUMERIC -> !pyNumberCheckNode.execute(inliningTarget, field);
                case QuoteStyle.QUOTE_ALL -> true;
                default -> false;
            };
            if (field == PNone.NONE) {
                WriteRowNode.joinAppend(inliningTarget, sb, dialect, null, quoted, createCodePointIteratorNode, nextNode, byteIndexOfCodePointNode, appendCodePointNode, appendStringNode, raiseNode);
            } else {
                TruffleString str = objectStrAsTruffleStringNode.execute(null, inliningTarget, field);
                WriteRowNode.joinAppend(inliningTarget, sb, dialect, str, quoted, createCodePointIteratorNode, nextNode, byteIndexOfCodePointNode, appendCodePointNode, appendStringNode, raiseNode);
            }
        }

        private static void joinAppend(Node inliningTarget, TruffleStringBuilder sb, CSVDialect dialect, TruffleString field, boolean quoted, TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, TruffleStringIterator.NextNode nextNode, TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.AppendStringNode appendStringNode, PRaiseNode.Lazy raiseNode) {
            if (!quoted) {
                quoted = WriteRowNode.needsQuotes(dialect, field, createCodePointIteratorNode, nextNode, byteIndexOfCodePointNode);
            }
            if (quoted) {
                appendStringNode.execute(sb, (AbstractTruffleString)dialect.quoteChar);
            }
            if (field != null) {
                TruffleStringIterator tsi = createCodePointIteratorNode.execute((AbstractTruffleString)field, PythonUtils.TS_ENCODING);
                while (tsi.hasNext()) {
                    boolean wantEscape = false;
                    int c = nextNode.execute(tsi);
                    if (WriteRowNode.needsEscape(dialect, c, byteIndexOfCodePointNode)) {
                        if (dialect.quoting == QuoteStyle.QUOTE_NONE) {
                            wantEscape = true;
                        } else {
                            if (c == dialect.quoteCharCodePoint) {
                                if (dialect.doubleQuote) {
                                    appendStringNode.execute(sb, (AbstractTruffleString)dialect.quoteChar);
                                } else {
                                    wantEscape = true;
                                }
                            } else if (c == dialect.escapeCharCodePoint) {
                                wantEscape = true;
                            }
                            if (!wantEscape) {
                                quoted = true;
                            }
                        }
                        if (wantEscape) {
                            if (dialect.escapeCharCodePoint == -1) {
                                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.CSVError, ErrorMessages.ESCAPE_WITHOUT_ESCAPECHAR);
                            }
                            appendStringNode.execute(sb, (AbstractTruffleString)dialect.escapeChar);
                        }
                    }
                    appendCodePointNode.execute(sb, c, 1, true);
                }
            }
            if (quoted) {
                appendStringNode.execute(sb, (AbstractTruffleString)dialect.quoteChar);
            }
        }

        private static boolean needsQuotes(CSVDialect dialect, TruffleString field, TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, TruffleStringIterator.NextNode nextNode, TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
            if (field == null) {
                return false;
            }
            TruffleStringIterator tsi = createCodePointIteratorNode.execute((AbstractTruffleString)field, PythonUtils.TS_ENCODING);
            while (tsi.hasNext()) {
                int c = nextNode.execute(tsi);
                if (!WriteRowNode.needsEscape(dialect, c, byteIndexOfCodePointNode) || dialect.quoting == QuoteStyle.QUOTE_NONE || c == dialect.quoteCharCodePoint && !dialect.doubleQuote || c == dialect.escapeCharCodePoint) continue;
                return true;
            }
            return false;
        }

        private static boolean needsEscape(CSVDialect dialect, int codePoint, TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
            return codePoint == dialect.delimiterCodePoint || codePoint == dialect.escapeCharCodePoint || codePoint == dialect.quoteCharCodePoint || byteIndexOfCodePointNode.execute((AbstractTruffleString)dialect.lineTerminator, codePoint, 0, dialect.lineTerminator.byteLength(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0;
        }
    }
}

