/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;

public final class PythonCextListBuiltins {

    static abstract class PyTruffleList_TryGetItems
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleList_TryGetItems() {
        }

        @Specialization
        static long doGeneric(PList self, Object outItems, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached PySequenceArrayWrapper.ToNativeStorageNode toNativeStorageNode) {
            SequenceStorage sequenceStorage = self.getSequenceStorage();
            if (sequenceStorage instanceof ObjectSequenceStorage) {
                ObjectSequenceStorage objectStorage = (ObjectSequenceStorage)sequenceStorage;
                sequenceStorage = toNativeStorageNode.execute(inliningTarget, objectStorage, false);
                self.setSequenceStorage(sequenceStorage);
            }
            if (sequenceStorage instanceof NativeObjectSequenceStorage) {
                NativeObjectSequenceStorage nativeStorage = (NativeObjectSequenceStorage)sequenceStorage;
                writePointerNode.write(outItems, nativeStorage.getPtr());
                return nativeStorage.length();
            }
            return 0L;
        }

        @Specialization
        static long doGeneric(PNone none, Object ignore) {
            return 0L;
        }
    }

    static abstract class PyTruffleList_ClearManagedOrGetItems
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleList_ClearManagedOrGetItems() {
        }

        @Specialization
        static long doGeneric(PList self, Object outItems, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CExtNodes.XDecRefPointerNode xDecRefPointerNode) {
            SequenceStorage sequenceStorage = self.getSequenceStorage();
            if (sequenceStorage instanceof NativeObjectSequenceStorage) {
                NativeObjectSequenceStorage nativeStorage = (NativeObjectSequenceStorage)sequenceStorage;
                writePointerNode.write(outItems, nativeStorage.getPtr());
                int length = nativeStorage.length();
                nativeStorage.setNewLength(0);
                return length;
            }
            assert (sequenceStorage instanceof ObjectSequenceStorage);
            ObjectSequenceStorage objectStorage = (ObjectSequenceStorage)sequenceStorage;
            int i = objectStorage.length();
            while (--i >= 0) {
                Object item = objectStorage.getObjectItemNormalized(i);
                if (!(item instanceof PythonAbstractNativeObject)) continue;
                PythonAbstractNativeObject nativeObject = (PythonAbstractNativeObject)item;
                xDecRefPointerNode.execute(inliningTarget, nativeObject.getPtr());
                objectStorage.setObjectItemNormalized(i, PNone.NONE);
            }
            return 0L;
        }
    }

    static abstract class PyList_Reverse
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_Reverse() {
        }

        @Specialization
        static int reverse(PList self, @Cached ListBuiltins.ListReverseNode reverseNode) {
            reverseNode.execute(null, self);
            return 0;
        }
    }

    static abstract class PyList_Insert
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyList_Insert() {
        }

        @Specialization
        static int insert(PList list, Object i, Object item, @Cached ListBuiltins.ListInsertNode insertNode) {
            insertNode.execute(null, list, i, item);
            return 0;
        }

        @Fallback
        int fallback(Object list, Object i, Object item) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_Sort
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_Sort() {
        }

        @Specialization
        static int append(PList list, @Cached ListBuiltins.ListSortNode sortNode) {
            sortNode.execute(null, list);
            return 0;
        }

        @Fallback
        int fallback(Object list) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_Size() {
        }

        @Specialization
        static int size(PList list) {
            return list.getSequenceStorage().length();
        }

        @Fallback
        int fallback(Object list) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class _PyList_Extend
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyList_Extend() {
        }

        @Specialization
        Object extend(PList list, Object iterable, @Cached ListBuiltins.ListExtendNode extendNode) {
            extendNode.execute(null, list, iterable);
            return PNone.NONE;
        }

        @Fallback
        Object fallback(Object list, Object iterable) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_SetSlice
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyList_SetSlice() {
        }

        @Specialization
        static int getSlice(PList list, Object iLow, Object iHigh, Object s, @Bind(value="this") Node inliningTarget, @Cached ListBuiltins.SetSubscriptNode setItemNode, @Cached PySliceNew sliceNode) {
            setItemNode.executeVoid(null, list, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE), s);
            return 0;
        }

        @Fallback
        int fallback(Object list, Object iLow, Object iHigh, Object s) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_GetSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyList_GetSlice() {
        }

        @Specialization
        Object getSlice(PList list, Object iLow, Object iHigh, @Bind(value="this") Node inliningTarget, @Cached ListBuiltins.GetItemNode getItemNode, @Cached PySliceNew sliceNode) {
            return getItemNode.execute(null, list, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE));
        }

        @Fallback
        Object fallback(Object list, Object iLow, Object iHigh) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_AsTuple
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_AsTuple() {
        }

        @Specialization
        Object append(PList list, @Cached TupleNodes.ConstructTupleNode constructTupleNode) {
            return constructTupleNode.execute(null, list);
        }

        @Fallback
        Object fallback(Object list) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_Append
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyList_Append() {
        }

        @Specialization
        int append(PList list, Object newItem, @Cached ListNodes.AppendNode appendNode) {
            if (newItem == PNone.NO_VALUE) {
                throw this.badInternalCall("newitem");
            }
            appendNode.execute(list, newItem);
            return 0;
        }

        @Fallback
        int fallback(Object list, Object newItem) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyList_GetItem() {
        }

        @Specialization
        static Object doPList(PList list, long key, @Bind(value="this") Node inliningTarget, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached SequenceStorageNodes.ListGeneralizationNode generalizationNode, @Cached SequenceStorageNodes.SetItemScalarNode setItemNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage sequenceStorage = list.getSequenceStorage();
            if (key < 0L || key >= (long)sequenceStorage.length()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.LIST_INDEX_OUT_OF_RANGE);
            }
            Object result = getItemNode.execute(inliningTarget, sequenceStorage, (int)key);
            Object promotedValue = promoteNode.execute(inliningTarget, result);
            if (promotedValue != null) {
                sequenceStorage = generalizationNode.execute(inliningTarget, sequenceStorage, promotedValue);
                list.setSequenceStorage(sequenceStorage);
                setItemNode.execute(inliningTarget, sequenceStorage, (int)key, promotedValue);
                return promotedValue;
            }
            return result;
        }

        @Fallback
        Object fallback(Object list, Object pos) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    static abstract class PyList_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_New() {
        }

        @Specialization(guards={"size < 0"})
        static Object newListError(long size, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_S, size);
        }

        @Specialization(guards={"size == 0"})
        static Object newEmptyList(long size, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createList(PythonUtils.EMPTY_OBJECT_ARRAY);
        }

        @Specialization(guards={"size > 0"})
        static Object newList(long size, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createList(PyList_New.array(size));
        }

        private static Object[] array(long size) {
            Object[] a = new Object[(int)size];
            Arrays.fill(a, PNone.NO_VALUE);
            return a;
        }
    }
}

