/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationExceptionProxyValue;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.internal.reflect.ConstantPool;
import sun.reflect.annotation.ExceptionProxy;

public final class AnnotationClassValue
extends AnnotationMemberValue {
    private final Class<?> value;

    static AnnotationMemberValue extract(ByteBuffer buf, ConstantPool cp, Class<?> container, boolean skip) {
        Object typeOrException = AnnotationMetadata.extractType(buf, cp, container, skip);
        if (skip) {
            return null;
        }
        if (typeOrException instanceof ExceptionProxy) {
            return new AnnotationExceptionProxyValue((ExceptionProxy)typeOrException);
        }
        return new AnnotationClassValue((Class)typeOrException);
    }

    AnnotationClassValue(Class<?> value) {
        this.value = value;
    }

    public Class<?> getValue() {
        return this.value;
    }

    @Override
    public List<Class<?>> getTypes() {
        return Collections.singletonList(this.value);
    }

    @Override
    public char getTag() {
        return 'c';
    }

    @Override
    public Object get(Class<?> memberType) {
        return AnnotationMetadata.checkResult(this.value, memberType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationClassValue that = (AnnotationClassValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

