/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.AMD64.class})
public class AMD64CPUFeatureRegionOp {

    public static final class AMD64CPUFeatureRegionLeaveOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AMD64CPUFeatureRegionLeaveOp> TYPE = LIRInstructionClass.create(AMD64CPUFeatureRegionLeaveOp.class);

        public AMD64CPUFeatureRegionLeaveOp() {
            super(TYPE);
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (masm.isCurrentRegionFeature((Enum)AMD64.CPUFeature.AVX)) {
                masm.vzeroupper();
            }
            masm.removeFeatures();
        }
    }

    public static final class AMD64CPUFeatureRegionEnterOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AMD64CPUFeatureRegionEnterOp> TYPE = LIRInstructionClass.create(AMD64CPUFeatureRegionEnterOp.class);
        private final EnumSet<AMD64.CPUFeature> features;

        public AMD64CPUFeatureRegionEnterOp(EnumSet<AMD64.CPUFeature> features) {
            super(TYPE);
            this.features = features;
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            masm.addFeatures(this.features);
        }
    }
}

