/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import org.graalvm.compiler.core.common.util.AbstractTypeReader;

public class NonmovableByteArrayTypeReader
extends AbstractTypeReader {
    protected final NonmovableArray<Byte> array;
    protected long byteIndex;

    public NonmovableByteArrayTypeReader(NonmovableArray<Byte> array, long byteIndex) {
        this.array = array;
        this.byteIndex = byteIndex;
    }

    public long getByteIndex() {
        return this.byteIndex;
    }

    public void setByteIndex(long byteIndex) {
        this.byteIndex = byteIndex;
    }

    public int getS1() {
        int result = NonmovableByteArrayReader.getS1(this.array, this.byteIndex);
        ++this.byteIndex;
        return result;
    }

    public int getU1() {
        int result = NonmovableByteArrayReader.getU1(this.array, this.byteIndex);
        ++this.byteIndex;
        return result;
    }

    public int getS2() {
        int result = NonmovableByteArrayReader.getS2(this.array, this.byteIndex);
        this.byteIndex += 2L;
        return result;
    }

    public int getU2() {
        int result = NonmovableByteArrayReader.getU2(this.array, this.byteIndex);
        this.byteIndex += 2L;
        return result;
    }

    public int getS4() {
        int result = NonmovableByteArrayReader.getS4(this.array, this.byteIndex);
        this.byteIndex += 4L;
        return result;
    }

    public long getU4() {
        long result = NonmovableByteArrayReader.getU4(this.array, this.byteIndex);
        this.byteIndex += 4L;
        return result;
    }

    public long getS8() {
        long result = NonmovableByteArrayReader.getS8(this.array, this.byteIndex);
        this.byteIndex += 8L;
        return result;
    }
}

