/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.LoomJDK;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Package_jdk_internal_vm_helper;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.word.UnsignedWord;

@TargetClass(className="Continuation", classNameProvider=Package_jdk_internal_vm_helper.class, onlyWith={LoomJDK.class})
public final class Target_jdk_internal_vm_Continuation {
    @Alias
    Runnable target;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Continuation internal;
    @Inject
    int pinCount;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    private boolean isEmpty() {
        return this.internal == null || this.internal.isEmpty();
    }

    @Alias
    public native Target_jdk_internal_vm_ContinuationScope getScope();

    @Alias
    public native Target_jdk_internal_vm_Continuation getParent();

    @Substitute
    @NeverInline(value="access stack pointer")
    private static int isPinned0(Target_jdk_internal_vm_ContinuationScope scope) {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        Target_jdk_internal_vm_Continuation cont = carrier.cont;
        if (cont != null) {
            while (true) {
                if (cont.pinCount != 0) {
                    return 2;
                }
                if (cont.getParent() == null || cont.getScope() == scope) break;
                cont = cont.getParent();
            }
            JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(CurrentIsolate.getCurrentThread());
            if (anchor.isNonNull() && cont.internal.getBaseSP().aboveThan((UnsignedWord)anchor.getLastJavaSP())) {
                return 3;
            }
        }
        return 0;
    }

    @Substitute
    boolean isStarted() {
        return this.internal != null && this.internal.isStarted();
    }

    @Alias
    public static native Target_jdk_internal_vm_Continuation getCurrentContinuation(Target_jdk_internal_vm_ContinuationScope var0);

    @Substitute
    static void enterSpecial(Target_jdk_internal_vm_Continuation c, boolean isContinue, boolean isVirtualThread) {
        assert (isVirtualThread);
        if (!isContinue) {
            assert (c.internal == null);
            c.internal = new Continuation(c::enter0);
        }
        c.internal.enter();
    }

    @Substitute
    private static int doYield() {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        Target_jdk_internal_vm_Continuation cont = carrier.cont;
        int pinnedReason = Target_jdk_internal_vm_Continuation.isPinned0(cont.getScope());
        if (pinnedReason != 0) {
            return pinnedReason;
        }
        return cont.internal.yield();
    }

    @Alias
    private native void finish();

    @Substitute
    private static void enter(Target_jdk_internal_vm_Continuation c, boolean isContinue) {
        try {
            c.target.run();
        }
        finally {
            c.finish();
        }
    }

    @Substitute
    private void enter0() {
        Target_jdk_internal_vm_Continuation.enter(this, false);
    }

    @Substitute
    static void pin() {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        if (carrier.cont != null) {
            if (carrier.cont.pinCount + 1 == 0) {
                throw new IllegalStateException("pin overflow");
            }
            ++carrier.cont.pinCount;
        }
    }

    @Substitute
    static void unpin() {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        if (carrier.cont != null) {
            if (carrier.cont.pinCount == 0) {
                throw new IllegalStateException("pin underflow");
            }
            --carrier.cont.pinCount;
        }
    }
}

