/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.ValidatableOptionKey;
import java.util.Objects;
import java.util.function.Consumer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class RuntimeOptionKey<T>
extends OptionKey<T>
implements ValidatableOptionKey {
    private final Consumer<RuntimeOptionKey<T>> validation;
    private final int flags;

    public RuntimeOptionKey(T defaultValue, RuntimeOptionKeyFlag ... flags) {
        this(defaultValue, (Consumer<RuntimeOptionKey<T>>)null, flags);
    }

    public RuntimeOptionKey(T defaultValue, Consumer<RuntimeOptionKey<T>> validation, RuntimeOptionKeyFlag ... flags) {
        super(defaultValue);
        this.validation = validation;
        this.flags = RuntimeOptionKey.computeFlags(flags);
    }

    public T getValue() {
        return (T)this.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    public void update(T value) {
        RuntimeOptionValues.singleton().update(this, value);
    }

    public void update(EconomicMap<OptionKey<?>, Object> values, Object newValue) {
        if (!SubstrateUtil.HOSTED && this.isImmutable() && !((RuntimeSupport)ImageSingletons.lookup(RuntimeSupport.class)).isUninitialized() && this.isDifferentValue(values, newValue)) {
            Object value = values.get((Object)this);
            throw new IllegalStateException("The runtime option '" + this.getName() + "' is immutable and can only be set during startup. Current value: " + value + ", new value: " + newValue);
        }
        super.update(values, newValue);
    }

    private boolean isDifferentValue(EconomicMap<OptionKey<?>, Object> values, Object newValue) {
        if (!values.containsKey((Object)this) && !Objects.equals(this.getDefaultValue(), newValue)) {
            return true;
        }
        Object value = values.get((Object)this);
        return !Objects.equals(value, newValue);
    }

    @Override
    public boolean hasBeenSet() {
        return this.hasBeenSet((OptionValues)RuntimeOptionValues.singleton());
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void validate() {
        if (this.validation != null) {
            this.validation.accept(this);
        }
    }

    public boolean shouldCopyToCompilationIsolate() {
        return this.hasFlag(RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
    }

    public boolean isImmutable() {
        return this.hasFlag(RuntimeOptionKeyFlag.Immutable);
    }

    private boolean hasFlag(RuntimeOptionKeyFlag flag) {
        return (this.flags & RuntimeOptionKey.flagBit(flag)) != 0;
    }

    private static int flagBit(RuntimeOptionKeyFlag flag) {
        assert (flag.ordinal() < 32);
        return 1 << flag.ordinal();
    }

    @Fold
    public T getHostedValue() {
        return (T)this.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    private static int computeFlags(RuntimeOptionKeyFlag[] flags) {
        int result = 0;
        for (RuntimeOptionKeyFlag flag : flags) {
            assert (flag.ordinal() <= 31);
            result |= RuntimeOptionKey.flagBit(flag);
        }
        return result;
    }

    public static enum RuntimeOptionKeyFlag {
        RelevantForCompilationIsolates,
        Immutable;

    }
}

