/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.word;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public final class SubstrateWordTypes
extends WordTypes {
    public SubstrateWordTypes(MetaAccessProvider metaAccess, JavaKind wordKind) {
        super(metaAccess, wordKind);
    }

    public boolean isWordOperation(ResolvedJavaMethod targetMethod) {
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)targetMethod, InvokeCFunctionPointer.class)) {
            return false;
        }
        return super.isWordOperation(targetMethod);
    }

    public ResolvedJavaMethod getWordOperation(ResolvedJavaMethod targetMethod, ResolvedJavaType callingContextType) {
        ResolvedJavaMethod wordOperation = super.getWordOperation(targetMethod, callingContextType);
        if (wordOperation == null) {
            UserError.abort("Could not determine the implementation of word operation %s. Check the use of annotations in your Java/C interface type declarations.", targetMethod);
        }
        return wordOperation;
    }
}

