/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.graal.reachability.MethodSummary;
import com.oracle.graal.reachability.MethodSummaryProvider;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.nodes.StructuredGraph;

public class MethodSummaryBasedHandler
implements ReachabilityMethodProcessingHandler {
    private final Timer summaryTimer;
    private final MethodSummaryProvider methodSummaryProvider;

    public MethodSummaryBasedHandler(MethodSummaryProvider methodSummaryProvider, TimerCollection timerCollection) {
        this.methodSummaryProvider = methodSummaryProvider;
        this.summaryTimer = timerCollection.createTimer("((summaries))");
    }

    @Override
    public void onMethodReachable(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method) {
        MethodSummary summary;
        try (Timer.StopTimer t = this.summaryTimer.start();){
            summary = this.methodSummaryProvider.getSummary(bb, method);
        }
        MethodSummaryBasedHandler.processSummary(bb, method, summary);
    }

    @Override
    public void processGraph(ReachabilityAnalysisEngine bb, StructuredGraph graph) {
        MethodSummary summary;
        try (Timer.StopTimer t = this.summaryTimer.start();){
            summary = this.methodSummaryProvider.getSummary(bb, graph);
        }
        ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)graph.method();
        MethodSummaryBasedHandler.processSummary(bb, method, summary);
    }

    private static void processSummary(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method, MethodSummary summary) {
        for (AnalysisMethod invokedMethod : summary.invokedMethods) {
            bb.markMethodInvoked((ReachabilityAnalysisMethod)invokedMethod);
        }
        for (AnalysisMethod invokedMethod : summary.implementationInvokedMethods) {
            bb.markMethodImplementationInvoked((ReachabilityAnalysisMethod)invokedMethod);
        }
        for (AnalysisType type : summary.accessedTypes) {
            bb.markTypeReachable(type);
        }
        for (AnalysisType type : summary.instantiatedTypes) {
            bb.markTypeInstantiated(type);
        }
        for (AnalysisField field : summary.readFields) {
            bb.markFieldRead(field);
            bb.markTypeReachable(field.getType());
        }
        for (AnalysisField field : summary.writtenFields) {
            bb.markFieldWritten(field);
        }
        for (JavaConstant constant : summary.embeddedConstants) {
            bb.handleEmbeddedConstant(method, constant);
        }
        for (AnalysisMethod rootMethod : summary.foreignCallTargets) {
            bb.addRootMethod(rootMethod, false);
        }
    }
}

