/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedTruffleCallNode
extends IsolatedObjectProxy<TruffleCallNode>
implements TruffleCallNode {
    IsolatedTruffleCallNode(ClientHandle<TruffleCallNode> node) {
        super(node);
    }

    public CompilableTruffleAST getCurrentCallTarget() {
        ClientHandle<SubstrateCompilableTruffleAST> astHandle = IsolatedTruffleCallNode.getCurrentCallTarget0(IsolatedCompileContext.get().getClient(), this.handle);
        return new IsolatedCompilableTruffleAST(astHandle);
    }

    public int getCallCount() {
        return IsolatedTruffleCallNode.getCallCount0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public boolean isInliningForced() {
        return IsolatedTruffleCallNode.isInliningForced0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<SubstrateCompilableTruffleAST> getCurrentCallTarget0(ClientIsolateThread client, ClientHandle<TruffleCallNode> nodeHandle) {
        TruffleCallNode node = IsolatedCompileClient.get().unhand(nodeHandle);
        CompilableTruffleAST target = node.getCurrentCallTarget();
        return IsolatedCompileClient.get().hand((SubstrateCompilableTruffleAST)target);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static int getCallCount0(ClientIsolateThread client, ClientHandle<TruffleCallNode> nodeHandle) {
        TruffleCallNode node = IsolatedCompileClient.get().unhand(nodeHandle);
        return node.getCallCount();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static boolean isInliningForced0(ClientIsolateThread client, ClientHandle<TruffleCallNode> nodeHandle) {
        TruffleCallNode node = IsolatedCompileClient.get().unhand(nodeHandle);
        return node.isInliningForced();
    }
}

