/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.graalvm.compiler.core.common.NumUtil;

public final class RelocatableBuffer {
    private final ByteBuffer byteBuffer;
    private final SortedMap<Integer, Info> relocations;

    public RelocatableBuffer(long size, ByteOrder byteOrder) {
        int intSize = NumUtil.safeToInt((long)size);
        this.byteBuffer = ByteBuffer.wrap(new byte[intSize]).order(byteOrder);
        this.relocations = new TreeMap<Integer, Info>();
    }

    public void addRelocationWithoutAddend(int key, ObjectFile.RelocationKind relocationKind, Object targetObject) {
        this.relocations.put(key, new Info(relocationKind, null, targetObject));
    }

    public void addRelocationWithAddend(int key, ObjectFile.RelocationKind relocationKind, Long explicitAddend, Object targetObject) {
        this.relocations.put(key, new Info(relocationKind, explicitAddend, targetObject));
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }

    public Set<Map.Entry<Integer, Info>> getSortedRelocations() {
        return Collections.unmodifiableSet(this.relocations.entrySet());
    }

    public byte[] getBackingArray() {
        return this.byteBuffer.array();
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    static final class Info {
        private final ObjectFile.RelocationKind relocationKind;
        private final Long explicitAddend;
        private final Object targetObject;

        Info(ObjectFile.RelocationKind kind, Long explicitAddend, Object targetObject) {
            this.relocationKind = kind;
            this.explicitAddend = explicitAddend;
            this.targetObject = targetObject;
        }

        public int getRelocationSize() {
            return ObjectFile.RelocationKind.getRelocationSize((ObjectFile.RelocationKind)this.relocationKind);
        }

        public ObjectFile.RelocationKind getRelocationKind() {
            return this.relocationKind;
        }

        public boolean hasExplicitAddend() {
            return this.explicitAddend != null;
        }

        public Long getExplicitAddend() {
            return this.explicitAddend;
        }

        public Object getTargetObject() {
            return this.targetObject;
        }

        public String toString() {
            return "RelocatableBuffer.Info(targetObject=" + this.targetObject + " relocationKind=" + this.relocationKind + " explicitAddend=" + this.explicitAddend + ")";
        }
    }
}

