/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionType;
import com.oracle.svm.hosted.c.GraalAccess;
import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public class ConstantAnnotationMarkerSubstitutionType
implements ResolvedJavaType,
OriginalClassProvider {
    private final ResolvedJavaType original;
    private final SubstitutionProcessor substitutionProcessor;

    public ConstantAnnotationMarkerSubstitutionType(ResolvedJavaType original, SubstitutionProcessor substitutionProcessor) {
        this.original = original;
        this.substitutionProcessor = substitutionProcessor;
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        ResolvedJavaType substitution = this.substitutionProcessor.lookup(other);
        if (substitution instanceof AnnotationSubstitutionType) {
            return false;
        }
        return this.original.isAssignableFrom(other);
    }

    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)this.original);
    }

    public boolean hasFinalizer() {
        return this.original.hasFinalizer();
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return this.original.hasFinalizableSubclass();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public boolean isInterface() {
        return this.original.isInterface();
    }

    public boolean isInstanceClass() {
        return this.original.isInstanceClass();
    }

    public boolean isPrimitive() {
        return this.original.isPrimitive();
    }

    public boolean isEnum() {
        return this.original.isEnum();
    }

    public boolean isInitialized() {
        return this.original.isInitialized();
    }

    public void initialize() {
        this.original.initialize();
    }

    public boolean isLinked() {
        return this.original.isLinked();
    }

    public ResolvedJavaType getHostClass() {
        return this.original.getHostClass();
    }

    public boolean isInstance(JavaConstant obj) {
        return this.original.isInstance(obj);
    }

    public ResolvedJavaType getSuperclass() {
        return this.original.getSuperclass();
    }

    public ResolvedJavaType[] getInterfaces() {
        return this.original.getInterfaces();
    }

    public ResolvedJavaType getSingleImplementor() {
        return this.original.getSingleImplementor();
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.original.findLeastCommonAncestor(otherType);
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        return this.original.findLeafConcreteSubtype();
    }

    public String getName() {
        return this.original.getName();
    }

    public ResolvedJavaType getComponentType() {
        return this.original.getComponentType();
    }

    public ResolvedJavaType getArrayClass() {
        return this.original.getArrayClass();
    }

    public JavaKind getJavaKind() {
        return this.original.getJavaKind();
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this.original.resolve(accessingClass);
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return this.original.resolveMethod(method, callerType);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return this.original.findUniqueConcreteMethod(method);
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        return this.original.getInstanceFields(includeSuperclasses);
    }

    public ResolvedJavaField[] getStaticFields() {
        return this.original.getStaticFields();
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return this.original.findInstanceFieldWithOffset(offset, expectedKind);
    }

    public String getSourceFileName() {
        return this.original.getSourceFileName();
    }

    public boolean isLocal() {
        return this.original.isLocal();
    }

    public boolean isMember() {
        return this.original.isMember();
    }

    public ResolvedJavaType getEnclosingType() {
        return this.original.getEnclosingType();
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return this.original.getDeclaredConstructors();
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.original.getDeclaredMethods();
    }

    public ResolvedJavaMethod getClassInitializer() {
        return this.original.getClassInitializer();
    }

    public void link() {
        this.original.link();
    }

    public boolean hasDefaultMethods() {
        return this.original.hasDefaultMethods();
    }

    public boolean declaresDefaultMethods() {
        return this.original.declaresDefaultMethods();
    }

    public boolean isCloneableWithAllocation() {
        return this.original.isCloneableWithAllocation();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.original.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.original.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.original.getDeclaredAnnotations();
    }
}

