/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

final class IsolateAwareSnippetReflectionProvider
implements SnippetReflectionProvider {
    IsolateAwareSnippetReflectionProvider() {
    }

    public JavaConstant forObject(Object object) {
        VMError.guarantee(!SubstrateOptions.shouldCompileInIsolates() || ImageHeapObjects.isInImageHeap(object));
        return SubstrateObjectConstant.forObject(object);
    }

    public <T> T asObject(Class<T> type, JavaConstant constant) {
        Object object = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject(type, constant), Object.class);
        VMError.guarantee(!SubstrateOptions.shouldCompileInIsolates() || ImageHeapObjects.isInImageHeap(object));
        return (T)object;
    }

    public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
        throw VMError.shouldNotReachHere();
    }

    public Class<?> originalClass(ResolvedJavaType type) {
        throw VMError.shouldNotReachHere();
    }
}

