/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.security.AccessControlContext;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;

@InternalVMMethod
class AccessControllerUtil {
    static final AccessControlContext NO_CONTEXT_SINGLETON;

    AccessControllerUtil() {
    }

    static Throwable wrapCheckedException(Throwable ex) {
        if (ex instanceof Exception && !(ex instanceof RuntimeException)) {
            return new PrivilegedActionException((Exception)ex);
        }
        return ex;
    }

    static {
        try {
            NO_CONTEXT_SINGLETON = (AccessControlContext)ReflectionUtil.lookupConstructor(AccessControlContext.class, (Class[])new Class[]{ProtectionDomain[].class, Boolean.TYPE}).newInstance(new ProtectionDomain[0], true);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

