/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.FrameAccess;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.WordBase;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class StackValueNode
extends FixedWithNextNode
implements LIRLowerable,
IterableNodeType {
    public static final NodeClass<StackValueNode> TYPE = NodeClass.create(StackValueNode.class);
    private static final int MAX_SIZE = 0xA00000;
    protected final int size;
    protected final StackSlotIdentity slotIdentity;
    protected StackSlotHolder stackSlotHolder;

    public StackValueNode(long numElements, long elementSize, StackSlotIdentity slotIdentity) {
        super(TYPE, FrameAccess.getWordStamp());
        if (UnsignedMath.aboveOrEqual((long)numElements, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)elementSize, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)(numElements * elementSize), (long)0xA00000L)) {
            throw new PermanentBailoutException("stack value has illegal size " + numElements + " * " + elementSize + ": " + slotIdentity.name);
        }
        this.size = (int)(numElements * elementSize);
        this.slotIdentity = slotIdentity;
    }

    public void generate(NodeLIRBuilderTool gen) {
        assert (this.stackSlotHolder != null) : "node not processed by StackValuePhase";
        assert (this.stackSlotHolder.gen == null || this.stackSlotHolder.gen == gen) : "Same stack slot holder used during multiple compilations, therefore caching a wrong value";
        this.stackSlotHolder.gen = gen;
        if (this.size == 0) {
            gen.setResult((ValueNode)this, (Value)new ConstantValue((ValueKind)gen.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (Constant)JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)0L)));
        } else {
            VirtualStackSlot slot = this.stackSlotHolder.slot;
            if (slot == null) {
                int wordSize = gen.getLIRGeneratorTool().target().wordSize;
                int slots = NumUtil.roundUp((int)this.size, (int)wordSize) / wordSize;
                this.stackSlotHolder.slot = slot = gen.getLIRGeneratorTool().allocateStackSlots(slots);
            }
            gen.setResult((ValueNode)this, (Value)gen.getLIRGeneratorTool().emitAddress((AllocatableValue)slot));
        }
    }

    @Node.NodeIntrinsic
    public static native WordBase stackValue(@Node.ConstantNodeParameter long var0, @Node.ConstantNodeParameter long var2, @Node.ConstantNodeParameter StackSlotIdentity var4);

    protected static class StackSlotHolder {
        protected VirtualStackSlot slot;
        protected final int size;
        protected NodeLIRBuilderTool gen;

        public StackSlotHolder(int size) {
            this.size = size;
        }
    }

    public static class StackSlotIdentity {
        protected final String name;

        public StackSlotIdentity(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

