/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.lir.DeoptSourcePositionInfoOp;
import java.util.List;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class DeoptSourcePositionInfoNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<DeoptSourcePositionInfoNode> TYPE = NodeClass.create(DeoptSourcePositionInfoNode.class);
    private final List<NodeSourcePosition> deoptimzationSourcePositions;

    public DeoptSourcePositionInfoNode(List<NodeSourcePosition> deoptimzationSourcePositions) {
        super(TYPE, StampFactory.forVoid());
        assert (deoptimzationSourcePositions.get(0) == null) : "First index is reserved for unknown source positions";
        this.deoptimzationSourcePositions = deoptimzationSourcePositions;
    }

    public void generate(NodeLIRBuilderTool generator) {
        generator.getLIRGeneratorTool().append((LIRInstruction)new DeoptSourcePositionInfoOp(this.deoptimzationSourcePositions));
    }
}

