/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.thread.JavaVMOperation;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public class AbstractRuntimeCodeInstaller {
    protected Pointer allocateCodeMemory(long size) {
        CodePointer result = RuntimeCodeInfoAccess.allocateCodeMemory(WordFactory.unsigned((long)size));
        if (result.isNull()) {
            throw new OutOfMemoryError();
        }
        return (Pointer)result;
    }

    protected void makeCodeMemoryReadOnly(Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryExecutableReadOnly((CodePointer)start, WordFactory.unsigned((long)size));
    }

    protected void makeCodeMemoryWriteableNonExecutable(Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryWriteableNonExecutable((CodePointer)start, WordFactory.unsigned((long)size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doInstallPrepared(SharedMethod method, CodeInfo codeInfo, SubstrateInstalledCode installedCode) {
        CodeInfoTether tether = RuntimeCodeInfoAccess.beforeInstallInCurrentIsolate(codeInfo, installedCode);
        try {
            AbstractRuntimeCodeInstaller.doInstallPreparedAndTethered(method, codeInfo, installedCode);
        }
        finally {
            CodeInfoAccess.releaseTether(codeInfo, tether);
        }
    }

    protected static void doInstallPreparedAndTethered(SharedMethod method, CodeInfo codeInfo, SubstrateInstalledCode installedCode) {
        Throwable[] errorBox = new Throwable[]{null};
        JavaVMOperation.enqueueBlockingSafepoint("Install code", () -> {
            try {
                assert (!installedCode.isValid() && !installedCode.isAlive());
                CodeInfoTable.getRuntimeCodeCache().addMethod(codeInfo);
                CodePointer codeStart = CodeInfoAccess.getCodeStart(codeInfo);
                AbstractRuntimeCodeInstaller.platformHelper().performCodeSynchronization(codeInfo);
                installedCode.setAddress(codeStart.rawValue(), method);
            }
            catch (Throwable e) {
                errorBox[0] = e;
            }
        });
        if (errorBox[0] != null) {
            throw AbstractRuntimeCodeInstaller.rethrow(errorBox[0]);
        }
    }

    protected static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    protected static RuntimeCodeInstallerPlatformHelper platformHelper() {
        return (RuntimeCodeInstallerPlatformHelper)ImageSingletons.lookup(RuntimeCodeInstallerPlatformHelper.class);
    }

    public static interface RuntimeCodeInstallerPlatformHelper {
        public void performCodeSynchronization(CodeInfo var1);
    }
}

