/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class ExponentialBackoff {
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final Duration DEFAULT_INITIAL_WAIT_PERIOD = Duration.of(250L, ChronoUnit.MILLIS);
    private final int maxRetries;
    private final Duration initialWaitPeriod;

    public ExponentialBackoff() {
        this(3, DEFAULT_INITIAL_WAIT_PERIOD);
    }

    private ExponentialBackoff(int maxRetries, Duration initialWaitPeriod) {
        if (maxRetries < 1) {
            throw new IllegalArgumentException("Max retries must be at least 1");
        }
        if (initialWaitPeriod.isNegative() || initialWaitPeriod.isZero()) {
            throw new IllegalArgumentException("Initial backoff wait delay must be strictly positive");
        }
        this.maxRetries = maxRetries;
        this.initialWaitPeriod = initialWaitPeriod;
    }

    public static ExponentialBackoff get() {
        return new ExponentialBackoff();
    }

    public ExponentialBackoff withMaxRetries(int maxRetries) {
        return new ExponentialBackoff(maxRetries, this.initialWaitPeriod);
    }

    public ExponentialBackoff withInitialWaitPeriod(Duration duration) {
        return new ExponentialBackoff(this.maxRetries, duration);
    }

    public <T> T supply(FailableSupplier<T> supplier) {
        int attempts = this.maxRetries + 1;
        Duration waitPeriod = this.initialWaitPeriod;
        Exception last = null;
        while (attempts > 0) {
            try {
                return supplier.get();
            }
            catch (Exception ex) {
                last = ex;
                --attempts;
                try {
                    Thread.sleep(waitPeriod.toMillis());
                    waitPeriod = waitPeriod.multipliedBy(2L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RetriableOperationFailedException("Thread was interrupted", e);
                }
            }
        }
        throw new RetriableOperationFailedException("Operation failed after " + this.maxRetries + " retries", last);
    }

    public void execute(FailableOperation operation) {
        this.supply(() -> {
            operation.run();
            return null;
        });
    }

    public static final class RetriableOperationFailedException
    extends RuntimeException {
        public RetriableOperationFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    public static interface FailableSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface FailableOperation {
        public void run() throws Exception;
    }
}

