/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.jts;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.C2D;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.jts.JTSConversionException;
import org.geolatte.geom.jts.PointSequenceCoordinateSequenceFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class JTS {
    private static final PointSequenceCoordinateSequenceFactory pscsFactory = new PointSequenceCoordinateSequenceFactory();
    private static final Map<Class<? extends org.locationtech.jts.geom.Geometry>, Class<? extends Geometry>> JTS2GLClassMap = new HashMap<Class<? extends org.locationtech.jts.geom.Geometry>, Class<? extends Geometry>>();
    private static final ConcurrentHashMap<Integer, GeometryFactory> geometryFactories = new ConcurrentHashMap();

    public static Class<? extends org.locationtech.jts.geom.Geometry> getCorrespondingJTSClass(Class<? extends Geometry> geometryClass) {
        if (geometryClass == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        for (Map.Entry<Class<? extends org.locationtech.jts.geom.Geometry>, Class<? extends Geometry>> entry : JTS2GLClassMap.entrySet()) {
            if (entry.getValue() != geometryClass) continue;
            return entry.getKey();
        }
        throw new NoSuchElementException(String.format("No mapping for class %s exists in JTS geom.", geometryClass.getCanonicalName()));
    }

    static Class<? extends Geometry> getCorrespondingGeolatteClass(Class<? extends org.locationtech.jts.geom.Geometry> jtsGeometryClass) {
        if (jtsGeometryClass == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        Class<? extends Geometry> corresponding = JTS2GLClassMap.get(jtsGeometryClass);
        if (corresponding == null) {
            throw new NoSuchElementException(String.format("No mapping for class %s exists in JTS geom.", jtsGeometryClass.getCanonicalName()));
        }
        return corresponding;
    }

    public static Geometry<?> from(org.locationtech.jts.geom.Geometry jtsGeometry) {
        if (jtsGeometry == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        Coordinate testCo = jtsGeometry.getCoordinate();
        boolean hasZ = testCo != null && !Double.isNaN(testCo.z);
        CoordinateReferenceSystem<?> crs = CrsRegistry.ifAbsentReturnProjected2D(jtsGeometry.getSRID());
        boolean hasM = JTS.isMeasuredCoordinate(testCo) && !Double.isNaN(testCo.getM());
        crs = CoordinateReferenceSystems.adjustTo(crs, hasZ, hasM);
        return JTS.from(jtsGeometry, crs);
    }

    private static boolean isMeasuredCoordinate(Coordinate testCo) {
        return testCo instanceof CoordinateXYZM || testCo instanceof CoordinateXYM;
    }

    public static <P extends Position> Geometry<P> from(org.locationtech.jts.geom.Geometry jtsGeometry, CoordinateReferenceSystem<P> crs) {
        if (jtsGeometry == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        if (jtsGeometry instanceof org.locationtech.jts.geom.Point) {
            return JTS.from((org.locationtech.jts.geom.Point)jtsGeometry, crs);
        }
        if (jtsGeometry instanceof org.locationtech.jts.geom.LineString) {
            return JTS.from((org.locationtech.jts.geom.LineString)jtsGeometry, crs);
        }
        if (jtsGeometry instanceof org.locationtech.jts.geom.Polygon) {
            return JTS.from((org.locationtech.jts.geom.Polygon)jtsGeometry, crs);
        }
        if (jtsGeometry instanceof org.locationtech.jts.geom.MultiPoint) {
            return JTS.from((org.locationtech.jts.geom.MultiPoint)jtsGeometry, crs);
        }
        if (jtsGeometry instanceof org.locationtech.jts.geom.MultiLineString) {
            return JTS.from((org.locationtech.jts.geom.MultiLineString)jtsGeometry, crs);
        }
        if (jtsGeometry instanceof org.locationtech.jts.geom.MultiPolygon) {
            return JTS.from((org.locationtech.jts.geom.MultiPolygon)jtsGeometry, crs);
        }
        if (jtsGeometry instanceof org.locationtech.jts.geom.GeometryCollection) {
            return JTS.from((org.locationtech.jts.geom.GeometryCollection)jtsGeometry, crs);
        }
        throw new JTSConversionException();
    }

    public static <P extends Position> org.locationtech.jts.geom.Geometry to(Geometry<P> geometry, GeometryFactory gFact) {
        if (geometry == null || gFact == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        if (geometry instanceof Point) {
            return JTS.to((Point)geometry, gFact);
        }
        if (geometry instanceof LineString) {
            return JTS.to((LineString)geometry, gFact);
        }
        if (geometry instanceof MultiPoint) {
            return JTS.to((MultiPoint)geometry, gFact);
        }
        if (geometry instanceof Polygon) {
            return JTS.to((Polygon)geometry, gFact);
        }
        if (geometry instanceof MultiLineString) {
            return JTS.to((MultiLineString)geometry, gFact);
        }
        if (geometry instanceof MultiPolygon) {
            return JTS.to((MultiPolygon)geometry, gFact);
        }
        if (geometry instanceof AbstractGeometryCollection) {
            return JTS.to((AbstractGeometryCollection)geometry, gFact);
        }
        throw new JTSConversionException();
    }

    public static <P extends Position> org.locationtech.jts.geom.Geometry to(Geometry<P> geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        GeometryFactory gFact = JTS.geometryFactory(geometry.getSRID());
        return JTS.to(geometry, gFact);
    }

    private static GeometryFactory geometryFactory(int srid) {
        return geometryFactories.computeIfAbsent(srid, id -> JTS.buildGeometryFactory(id));
    }

    private static GeometryFactory buildGeometryFactory(int srid) {
        return new GeometryFactory(new PrecisionModel(), srid, (CoordinateSequenceFactory)pscsFactory);
    }

    public static Envelope<C2D> from(org.locationtech.jts.geom.Envelope jtsEnvelope) {
        if (jtsEnvelope == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        return new Envelope<C2D>(jtsEnvelope.getMinX(), jtsEnvelope.getMinY(), jtsEnvelope.getMaxX(), jtsEnvelope.getMaxY(), CoordinateReferenceSystems.PROJECTED_2D_METER);
    }

    public static <P extends Position> Envelope<P> from(org.locationtech.jts.geom.Envelope jtsEnvelope, CoordinateReferenceSystem<P> crs) {
        if (jtsEnvelope == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        return new Envelope<P>(jtsEnvelope.getMinX(), jtsEnvelope.getMinY(), jtsEnvelope.getMaxX(), jtsEnvelope.getMaxY(), crs);
    }

    public static org.locationtech.jts.geom.Envelope to(Envelope<?> env) {
        if (env == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        return new org.locationtech.jts.geom.Envelope(((Position)env.lowerLeft()).getCoordinate(0), ((Position)env.upperRight()).getCoordinate(0), ((Position)env.lowerLeft()).getCoordinate(1), ((Position)env.upperRight()).getCoordinate(1));
    }

    private static <P extends Position> MultiPolygon<P> from(org.locationtech.jts.geom.MultiPolygon jtsGeometry, CoordinateReferenceSystem<P> crs) {
        if (jtsGeometry.getNumGeometries() == 0) {
            return new MultiPolygon<P>(crs);
        }
        Polygon[] polygons = new Polygon[jtsGeometry.getNumGeometries()];
        for (int i = 0; i < jtsGeometry.getNumGeometries(); ++i) {
            polygons[i] = JTS.from((org.locationtech.jts.geom.Polygon)jtsGeometry.getGeometryN(i), crs);
        }
        return new MultiPolygon(polygons);
    }

    private static <P extends Position> Polygon<P> from(org.locationtech.jts.geom.Polygon jtsGeometry, CoordinateReferenceSystem<P> crs) {
        if (jtsGeometry.isEmpty()) {
            return new Polygon<P>(crs);
        }
        LinearRing[] rings = new LinearRing[jtsGeometry.getNumInteriorRing() + 1];
        LinearRing<P> extRing = JTS.from(jtsGeometry.getExteriorRing(), crs);
        rings[0] = new LinearRing(extRing.getPositions(), extRing.getCoordinateReferenceSystem());
        for (int i = 1; i < rings.length; ++i) {
            LinearRing<P> intRing = JTS.from(jtsGeometry.getInteriorRingN(i - 1), crs);
            rings[i] = new LinearRing<P>(intRing);
        }
        return new Polygon(rings);
    }

    private static <P extends Position> MultiLineString<P> from(org.locationtech.jts.geom.MultiLineString jtsGeometry, CoordinateReferenceSystem<P> crs) {
        if (jtsGeometry.getNumGeometries() == 0) {
            return new MultiLineString<P>(crs);
        }
        LineString[] linestrings = new LineString[jtsGeometry.getNumGeometries()];
        for (int i = 0; i < linestrings.length; ++i) {
            linestrings[i] = JTS.from((org.locationtech.jts.geom.LineString)jtsGeometry.getGeometryN(i), crs);
        }
        return new MultiLineString(linestrings);
    }

    private static <P extends Position> GeometryCollection<P> from(org.locationtech.jts.geom.GeometryCollection jtsGeometry, CoordinateReferenceSystem<P> crs) {
        if (jtsGeometry.getNumGeometries() == 0) {
            return new GeometryCollection<P>(crs);
        }
        Geometry[] geoms = new Geometry[jtsGeometry.getNumGeometries()];
        for (int i = 0; i < jtsGeometry.getNumGeometries(); ++i) {
            geoms[i] = JTS.from(jtsGeometry.getGeometryN(i), crs);
        }
        return new GeometryCollection(geoms);
    }

    private static <P extends Position> LineString<P> from(org.locationtech.jts.geom.LineString jtsLineString, CoordinateReferenceSystem<P> crs) {
        CoordinateSequence cs = jtsLineString.getCoordinateSequence();
        return new LineString<P>(pscsFactory.toPositionSequence(cs, crs.getPositionClass(), crs), crs);
    }

    private static <P extends Position> LinearRing<P> from(org.locationtech.jts.geom.LinearRing jtsLinearRing, CoordinateReferenceSystem<P> crs) {
        CoordinateSequence cs = jtsLinearRing.getCoordinateSequence();
        return new LinearRing<P>(pscsFactory.toPositionSequence(cs, crs.getPositionClass(), crs), crs);
    }

    private static <P extends Position> MultiPoint<P> from(org.locationtech.jts.geom.MultiPoint jtsMultiPoint, CoordinateReferenceSystem<P> crs) {
        if (jtsMultiPoint == null || jtsMultiPoint.getNumGeometries() == 0) {
            return new MultiPoint<P>(crs);
        }
        Point[] points = new Point[jtsMultiPoint.getNumGeometries()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = JTS.from((org.locationtech.jts.geom.Point)jtsMultiPoint.getGeometryN(i), crs);
        }
        return new MultiPoint(points);
    }

    private static <P extends Position> Point<P> from(org.locationtech.jts.geom.Point jtsPoint, CoordinateReferenceSystem<P> crs) {
        CoordinateSequence cs = jtsPoint.getCoordinateSequence();
        return new Point<PositionSequence<P>>(pscsFactory.toPositionSequence(cs, crs.getPositionClass(), crs), crs);
    }

    private static <P extends Position> org.locationtech.jts.geom.Polygon to(Polygon<P> polygon, GeometryFactory gFact) {
        org.locationtech.jts.geom.LinearRing shell = JTS.to(polygon.getExteriorRing(), gFact);
        org.locationtech.jts.geom.LinearRing[] holes = new org.locationtech.jts.geom.LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = JTS.to(polygon.getInteriorRingN(i), gFact);
        }
        return gFact.createPolygon(shell, holes);
    }

    private static <P extends Position> org.locationtech.jts.geom.Point to(Point<P> point, GeometryFactory gFact) {
        return gFact.createPoint(JTS.sequenceOf(point));
    }

    private static <P extends Position> org.locationtech.jts.geom.LineString to(LineString<P> lineString, GeometryFactory gFact) {
        return gFact.createLineString(JTS.sequenceOf(lineString));
    }

    private static <P extends Position> org.locationtech.jts.geom.LinearRing to(LinearRing<P> linearRing, GeometryFactory gFact) {
        return gFact.createLinearRing(JTS.sequenceOf(linearRing));
    }

    private static <P extends Position> org.locationtech.jts.geom.MultiPoint to(MultiPoint<P> multiPoint, GeometryFactory gFact) {
        org.locationtech.jts.geom.Point[] points = new org.locationtech.jts.geom.Point[multiPoint.getNumGeometries()];
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            points[i] = JTS.to((Point)multiPoint.getGeometryN(i), gFact);
        }
        return gFact.createMultiPoint(points);
    }

    private static <P extends Position> org.locationtech.jts.geom.MultiLineString to(MultiLineString<P> multiLineString, GeometryFactory gFact) {
        org.locationtech.jts.geom.LineString[] lineStrings = new org.locationtech.jts.geom.LineString[multiLineString.getNumGeometries()];
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            lineStrings[i] = JTS.to((LineString)multiLineString.getGeometryN(i), gFact);
        }
        return gFact.createMultiLineString(lineStrings);
    }

    private static <P extends Position> org.locationtech.jts.geom.MultiPolygon to(MultiPolygon<P> multiPolygon, GeometryFactory gFact) {
        org.locationtech.jts.geom.Polygon[] polygons = new org.locationtech.jts.geom.Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            polygons[i] = JTS.to((Polygon)multiPolygon.getGeometryN(i), gFact);
        }
        return gFact.createMultiPolygon(polygons);
    }

    private static <P extends Position> org.locationtech.jts.geom.GeometryCollection to(AbstractGeometryCollection<P, Geometry<P>> collection, GeometryFactory gFact) {
        org.locationtech.jts.geom.Geometry[] geoms = new org.locationtech.jts.geom.Geometry[collection.getNumGeometries()];
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            geoms[i] = JTS.to(collection.getGeometryN(i));
        }
        return gFact.createGeometryCollection(geoms);
    }

    private static CoordinateSequence sequenceOf(Geometry geometry) {
        if (geometry == null) {
            throw new JTSConversionException("Can't convert null geometries.");
        }
        return (CoordinateSequence)geometry.getPositions();
    }

    static {
        JTS2GLClassMap.put(org.locationtech.jts.geom.Point.class, Point.class);
        JTS2GLClassMap.put(org.locationtech.jts.geom.LineString.class, LineString.class);
        JTS2GLClassMap.put(org.locationtech.jts.geom.LinearRing.class, LinearRing.class);
        JTS2GLClassMap.put(org.locationtech.jts.geom.Polygon.class, Polygon.class);
        JTS2GLClassMap.put(org.locationtech.jts.geom.GeometryCollection.class, GeometryCollection.class);
        JTS2GLClassMap.put(org.locationtech.jts.geom.MultiPoint.class, MultiPoint.class);
        JTS2GLClassMap.put(org.locationtech.jts.geom.MultiLineString.class, MultiLineString.class);
        JTS2GLClassMap.put(org.locationtech.jts.geom.MultiPolygon.class, MultiPolygon.class);
    }
}

