/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.Position;
import org.geolatte.geom.builder.DSL;
import org.geolatte.geom.generator.Generator;

class DefaultGeometryCollectionGenerator<P extends Position>
implements Generator<GeometryCollection<P>> {
    private final int numGeoms;
    private final Generator<Geometry<P>> baseGenerator;

    DefaultGeometryCollectionGenerator(int numGeoms, Generator<Geometry<P>> baseGenerator, Random rnd) {
        this.numGeoms = numGeoms;
        this.baseGenerator = baseGenerator;
    }

    @Override
    public GeometryCollection<P> generate() {
        Geometry[] geoms = new Geometry[this.numGeoms - 1];
        this.baseGenerator.generateArray(geoms);
        return DSL.geometrycollection(this.baseGenerator.generate(), geoms);
    }
}

