/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.Position;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.CoordinateOperation;

public interface TransformOperation<P extends Position, Q extends Position> {
    public CoordinateReferenceSystem<P> getSource();

    public CoordinateReferenceSystem<Q> getTarget();

    public CoordinateOperation getOperation();

    default public Q forward(P pos) {
        double[] out = ((Position)pos).toArray(null);
        this.getOperation().forward(((Position)pos).toArray(null), out);
        return Positions.mkPosition(this.getTarget().getPositionClass(), out);
    }

    default public P reverse(Q pos) {
        double[] out = ((Position)pos).toArray(null);
        this.getOperation().reverse(((Position)pos).toArray(null), out);
        return Positions.mkPosition(this.getSource().getPositionClass(), out);
    }

    public TransformOperation<Q, P> reversed();
}

