/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CompoundCoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearCoordinateReferenceSystem;
import org.geolatte.geom.crs.OneDimensionCoordinateReferenceSystem;
import org.geolatte.geom.crs.SingleCoordinateReferenceSystem;
import org.geolatte.geom.crs.VerticalCoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.CoordinateOperations;
import org.geolatte.geom.crs.trans.ExtendedCoordinateOperation;
import org.geolatte.geom.crs.trans.TransformOperation;

class DefaultTransformOperation<P extends Position, Q extends Position>
implements TransformOperation<P, Q> {
    private final CoordinateReferenceSystem<P> source;
    private final CoordinateReferenceSystem<Q> target;
    private CoordinateOperation op;

    DefaultTransformOperation(CoordinateReferenceSystem<P> source, CoordinateReferenceSystem<Q> target) {
        SingleCoordinateReferenceSystem<?> targetBase;
        SingleCoordinateReferenceSystem<?> sourceBase;
        this.source = source;
        this.target = target;
        VerticalCoordinateReferenceSystem sourceVertical = null;
        LinearCoordinateReferenceSystem sourceLinear = null;
        if (source.isCompound()) {
            CompoundCoordinateReferenceSystem cSource = (CompoundCoordinateReferenceSystem)source;
            sourceBase = cSource.getBase();
            sourceVertical = cSource.getVertical().orElse(null);
            sourceLinear = cSource.getLinear().orElse(null);
        } else {
            sourceBase = (SingleCoordinateReferenceSystem<?>)source;
        }
        VerticalCoordinateReferenceSystem targetVertical = null;
        LinearCoordinateReferenceSystem targetLinear = null;
        if (target.isCompound()) {
            CompoundCoordinateReferenceSystem cTarget = (CompoundCoordinateReferenceSystem)target;
            targetBase = cTarget.getBase();
            targetVertical = cTarget.getVertical().orElse(null);
            targetLinear = cTarget.getLinear().orElse(null);
        } else {
            targetBase = (SingleCoordinateReferenceSystem<?>)target;
        }
        this.op = CoordinateOperations.transform(sourceBase, targetBase);
        if (targetVertical != null || sourceVertical != null) {
            this.op = this.extend(this.op, sourceVertical, targetVertical);
        }
        if (targetLinear != null || sourceLinear != null) {
            this.op = this.extend(this.op, sourceLinear, targetLinear);
        }
    }

    DefaultTransformOperation(CoordinateReferenceSystem<P> source, CoordinateReferenceSystem<Q> target, CoordinateOperation op) {
        this.op = op;
        this.source = source;
        this.target = target;
    }

    private CoordinateOperation extend(CoordinateOperation baseOp, OneDimensionCoordinateReferenceSystem sourceVertical, OneDimensionCoordinateReferenceSystem targetVertical) {
        return new ExtendedCoordinateOperation(baseOp, sourceVertical, targetVertical);
    }

    @Override
    public CoordinateReferenceSystem<P> getSource() {
        return this.source;
    }

    @Override
    public CoordinateReferenceSystem<Q> getTarget() {
        return this.target;
    }

    @Override
    public CoordinateOperation getOperation() {
        return this.op;
    }

    @Override
    public TransformOperation<Q, P> reversed() {
        return new DefaultTransformOperation<Q, P>(this.target, this.source, this.op.reversed());
    }
}

