/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsIdentifiable;
import org.geolatte.geom.crs.LinearUnit;

public abstract class CoordinateReferenceSystem<P extends Position>
extends CrsIdentifiable {
    private final CoordinateSystem<P> coordinateSystem;

    public CoordinateReferenceSystem(CrsId crsId, String name, CoordinateSystem<P> coordinateSystem) {
        super(crsId, name);
        if (coordinateSystem == null) {
            throw new IllegalArgumentException("No null arguments allowed");
        }
        this.coordinateSystem = coordinateSystem;
    }

    public Class<P> getPositionClass() {
        return this.coordinateSystem.getPositionClass();
    }

    public CoordinateSystem<P> getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public int getCoordinateDimension() {
        return this.getCoordinateSystem().getCoordinateDimension();
    }

    public CoordinateSystemAxis getAxis(int idx) {
        return this.coordinateSystem.getAxis(idx);
    }

    public int getAxisIndex(CoordinateSystemAxis axis) {
        return this.getCoordinateSystem().getAxisIndex(axis);
    }

    public boolean isCompound() {
        return false;
    }

    public <Q extends P> CoordinateReferenceSystem<Q> addVerticalSystem(LinearUnit unit, Class<Q> clazz) {
        return CoordinateReferenceSystems.addVerticalSystem(this, clazz, unit);
    }

    public <Q extends P> CoordinateReferenceSystem<Q> addLinearSystem(LinearUnit unit, Class<Q> clazz) {
        return CoordinateReferenceSystems.addLinearSystem(this, clazz, unit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CoordinateReferenceSystem that = (CoordinateReferenceSystem)o;
        return this.coordinateSystem.equals(that.coordinateSystem);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.coordinateSystem.hashCode();
        return result;
    }

    public boolean hasZ() {
        return this.getCoordinateSystem().hasZ();
    }

    public boolean hasM() {
        return this.getCoordinateSystem().hasM();
    }

    public String toString() {
        return this.getName() + " (" + this.getCrsId().toString() + ")";
    }
}

