/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;

public enum OpenGisType {
    POINT(1, Point.class),
    LINESTRING(2, LineString.class),
    POLYGON(3, Polygon.class),
    MULTIPOINT(4, MultiPoint.class),
    MULTILINESTRING(5, MultiLineString.class),
    MULTIPOLYGON(6, MultiPolygon.class),
    GEOMETRYCOLLECTION(7, AbstractGeometryCollection.class),
    INVALID_TYPE(0, null);

    final byte byteValue;
    final Class<? extends Geometry> geomClass;

    private OpenGisType(byte v, Class<? extends Geometry> geomClass) {
        this.byteValue = v;
        this.geomClass = geomClass;
    }

    boolean typeOf(Object o) {
        return this.geomClass.isAssignableFrom(o.getClass());
    }

    static OpenGisType valueOf(byte b) {
        for (OpenGisType t : OpenGisType.values()) {
            if (t.byteValue != b) continue;
            return t;
        }
        return INVALID_TYPE;
    }
}

